/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.client;

import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.remote.RemoteClient;
import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import hep.aida.ref.remote.rmi.RmiRemoteUtils;
import hep.aida.ref.remote.rmi.client.RmiRemoteServer;
import hep.aida.ref.remote.rmi.interfaces.RmiServer;
import java.net.InetAddress;
import java.rmi.Naming;
import java.util.Iterator;
import java.util.Map;

public class RmiRemoteClient
extends RemoteClient {
    private Map options;

    public RmiRemoteClient(IDevMutableStore store, Map options) {
        super(store);
        this.options = options;
    }

    public RmiRemoteClient(IDevMutableStore store, boolean duplex, Map options) {
        super(store, duplex);
        this.options = options;
    }

    @Override
    protected void init() {
        super.init();
        this.clientID = "RmiRemoteClient";
        try {
            this.clientID = System.getProperty("user.name", "RmiRemoteClient");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (localHost != null) {
            this.clientID = this.clientID + "@" + localHost;
        }
        this.clientID = this.clientID + "-" + RmiRemoteUtils.getCurrentDateString();
    }

    @Override
    protected AidaTreeServer getServer() {
        RmiRemoteServer treeServer = null;
        try {
            RmiServer server = null;
            String rmiServerName = null;
            Iterator it = this.options.keySet().iterator();
            boolean blk = false;
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)this.options.get(key);
                this.remoteLogger.fine("Key = " + key + " \tValue = " + value);
                if (key.equalsIgnoreCase("RmiServerName")) {
                    rmiServerName = value;
                    continue;
                }
                if (key.equalsIgnoreCase("blocking")) {
                    if ("false".equals(value)) {
                        blk = false;
                        continue;
                    }
                    blk = true;
                    continue;
                }
                if (!key.equalsIgnoreCase("updateInterval")) continue;
                long millis = this.updateInterval;
                try {
                    double d = Double.parseDouble(value);
                    millis = (long)(d * 1000.0);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("RmiRemoteClient.getServer :: Can not set updateInterval: \"" + value + "\"\n\t" + nfe.getMessage());
                }
                this.setUpdateTime(millis);
            }
            this.setBlocking(blk);
            server = (RmiServer)Naming.lookup(rmiServerName);
            treeServer = new RmiRemoteServer(server);
        }
        catch (Exception e) {
            throw new RemoteConnectionException(e.getMessage(), e);
        }
        return treeServer;
    }

    @Override
    public boolean disconnect() {
        boolean ok = super.disconnect();
        if (this.options != null) {
            this.options.clear();
        }
        this.options = null;
        return ok;
    }
}

