/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteServerQueue
implements Runnable {
    protected AidaTreeClient client;
    protected List queue = new ArrayList(100);
    protected List holdQueue = new ArrayList(100);
    protected long blockingTimeout = 10000L;
    protected boolean keepRunning = true;
    protected boolean blocking;
    protected Object blockingLock;
    protected boolean hold;
    protected Logger remoteLogger;

    public RemoteServerQueue() {
        this(null);
    }

    public RemoteServerQueue(AidaTreeClient client) {
        this.client = client;
        this.hold = false;
        this.blocking = false;
        this.blockingLock = new Object();
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.remoteLogger.fine("RemoteServerQueue: START");
        if (client != null) {
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean b) {
        this.blocking = b;
        Object object = this.blockingLock;
        synchronized (object) {
            this.blockingLock.notify();
        }
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.keepRunning = false;
        this.queue.clear();
        this.queue = null;
        this.holdQueue.clear();
        this.notify();
        Object object = this.blockingLock;
        synchronized (object) {
            this.blockingLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHold(boolean h) {
        if (h) {
            this.hold = h;
        } else {
            RemoteServerQueue remoteServerQueue = this;
            synchronized (remoteServerQueue) {
                this.hold = h;
                this.queue.addAll(this.holdQueue);
                this.holdQueue.clear();
                this.notify();
                Object object = this.blockingLock;
                synchronized (object) {
                    this.blockingLock.notify();
                }
            }
        }
    }

    public int size() {
        return this.queue == null ? 0 : this.queue.size();
    }

    public void schedule(AidaUpdateEvent event) {
        this.remoteLogger.finest("RemoteServerQueue.schedule id=" + event.id() + ", path=" + event.path() + ", type=" + event.nodeType() + ", event=" + event);
        if (this.keepRunning) {
            this.addToQueue(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AidaUpdateEvent[] getEvents() {
        Object object;
        AidaUpdateEvent[] events = new AidaUpdateEvent[]{};
        int size = this.size();
        this.remoteLogger.finest("RemoteServerQueue.getEvents size=" + size);
        if (size == 0) {
            if (this.client == null && this.blocking) {
                object = this.blockingLock;
                synchronized (object) {
                    try {
                        this.blockingLock.wait(this.blockingTimeout);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return events;
        }
        object = this;
        synchronized (object) {
            size = this.size();
            if (size == 0) {
                return events;
            }
            events = new AidaUpdateEvent[size];
            this.queue.toArray(events);
            this.queue.clear();
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToQueue(AidaUpdateEvent event) {
        RemoteServerQueue remoteServerQueue = this;
        synchronized (remoteServerQueue) {
            if (this.hold) {
                this.holdQueue.add(event);
            } else {
                this.queue.add(event);
                this.notify();
                Object object = this.blockingLock;
                synchronized (object) {
                    this.blockingLock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int size = 0;
        AidaUpdateEvent[] events = null;
        while (this.keepRunning) {
            try {
                RemoteServerQueue remoteServerQueue = this;
                synchronized (remoteServerQueue) {
                    if (this.size() == 0) {
                        this.wait();
                    }
                    if (this.queue == null) {
                        return;
                    }
                    size = this.size();
                    if (size > 0) {
                        events = this.getEvents();
                    }
                }
                this.remoteLogger.finest("RemoteServerQueue.run Processing: " + size);
                if (events == null && events.length <= 0 || this.client == null) continue;
                this.client.stateChanged(events);
            }
            catch (InterruptedException e2) {
                this.remoteLogger.log(Level.INFO, "RemoteServerOueue InterruptedException.", e2);
                this.remoteLogger.log(Level.FINE, "", e2.getStackTrace());
            }
            catch (Exception e3) {
                this.remoteLogger.log(Level.INFO, "Exception in RemoteServerQueue: ", e3);
                this.remoteLogger.log(Level.FINE, "", e3.getStackTrace());
            }
        }
    }
}

