/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnnotation;
import hep.aida.IFunction;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.function.CodeletUtils;
import hep.aida.ref.function.FunctionCatalog;
import java.util.ArrayList;

public class SumOfFunctions
extends ManagedObject
implements IFunction {
    private ArrayList functions;
    private boolean hasFunctions = false;
    private int dimension;
    private Annotation annotation = new Annotation();
    private String[] parameters;
    private double[] parValues;
    private String name;
    private String title;

    public SumOfFunctions(String name, ArrayList functions) {
        super(name);
        this.functions = functions;
        this.name = name;
        this.updateFunction();
    }

    void updateFunction() {
        if (this.nFunctions() > 0) {
            this.hasFunctions = true;
            this.dimension = this.function(0).dimension();
            int nPars = this.function(0).numberOfParameters();
            for (int i = 1; i < this.nFunctions(); ++i) {
                if (this.function(i).dimension() != this.dimension) {
                    throw new IllegalArgumentException("To be added functions must have the same dimension");
                }
                nPars += this.function(i).numberOfParameters();
            }
            this.parameters = new String[nPars];
            this.parValues = new double[nPars];
            int count = 0;
            for (int i = 0; i < this.nFunctions(); ++i) {
                String[] pars = this.function(i).parameterNames();
                for (int j = 0; j < pars.length; ++j) {
                    String parName = pars[j];
                    for (int k = 0; k < this.parameters.length; ++k) {
                        if (!parName.equals(this.parameters[k])) continue;
                        parName = parName + "_" + this.indexOfFunction(this.function(i));
                    }
                    this.parameters[count++] = parName;
                }
            }
            this.title = this.codeletString();
        } else {
            this.hasFunctions = false;
            this.parameters = null;
            this.parValues = null;
            this.title = "";
        }
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public String normalizationParameter() {
        throw new UnsupportedOperationException();
    }

    public String codeletString() {
        if (this.hasFunctions) {
            String codelet = FunctionCatalog.prefix + CodeletUtils.modelFromCodelet(this.function(0).codeletString());
            for (int i = 1; i < this.nFunctions(); ++i) {
                codelet = codelet + " + " + CodeletUtils.modelFromCodelet(this.function(i).codeletString());
            }
            codelet = codelet + ":catalog";
            return codelet;
        }
        return null;
    }

    public int dimension() {
        return this.dimension;
    }

    public double[] gradient(double[] values) {
        if (!this.providesGradient()) {
            throw new IllegalArgumentException("This function does not provide the gradient.");
        }
        double[] gradient = this.function(0).gradient(values);
        for (int i = 1; i < this.nFunctions(); ++i) {
            double[] tmpGrad = this.function(i).gradient(values);
            for (int j = 0; j < this.dimension(); ++j) {
                int n = j;
                gradient[n] = gradient[n] + tmpGrad[j];
            }
        }
        return gradient;
    }

    public int indexOfParameter(String str) {
        for (int i = 0; i < this.parameters.length; ++i) {
            if (!str.equals(this.parameters[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Illegal parameter name " + str);
    }

    public boolean isEqual(IFunction iFunction) {
        return false;
    }

    public int numberOfParameters() {
        return this.parameters.length;
    }

    public double parameter(String str) {
        int index = this.indexOfParameter(str);
        for (int i = 0; i < this.nFunctions(); ++i) {
            IFunction func = this.function(i);
            int nPars = func.numberOfParameters();
            if (index > nPars - 1) {
                index -= nPars;
                continue;
            }
            return func.parameter(this.parameterNames()[index]);
        }
        throw new IllegalArgumentException("Illegal parameter " + str);
    }

    public String[] parameterNames() {
        return this.parameters;
    }

    public double[] parameters() {
        int count = 0;
        for (int i = 0; i < this.nFunctions(); ++i) {
            double[] pars = this.function(i).parameters();
            for (int j = 0; j < pars.length; ++j) {
                this.parValues[count++] = pars[j];
            }
        }
        return this.parValues;
    }

    public boolean providesGradient() {
        for (int i = 0; i < this.nFunctions(); ++i) {
            if (this.function(i).providesGradient()) continue;
            return false;
        }
        return true;
    }

    public void setParameter(String str, double param) throws IllegalArgumentException {
        int index = this.indexOfParameter(str);
        for (int i = 0; i < this.nFunctions(); ++i) {
            IFunction func = this.function(i);
            int nPars = func.numberOfParameters();
            if (index > nPars - 1) {
                index -= nPars;
                continue;
            }
            func.setParameter(func.parameterNames()[index], param);
            return;
        }
    }

    public void setParameters(double[] values) throws IllegalArgumentException {
        if (values.length != this.numberOfParameters()) {
            throw new IllegalArgumentException("Illegal size " + values.length + ". It has to be equal to the number of parameters " + this.numberOfParameters() + ".");
        }
        for (int i = 0; i < values.length; ++i) {
            this.setParameter(this.parameters[i], values[i]);
        }
    }

    public void setTitle(String str) throws IllegalArgumentException {
        this.title = str;
    }

    public String title() {
        return this.title;
    }

    public double value(double[] values) {
        double result = 0.0;
        for (int i = 0; i < this.nFunctions(); ++i) {
            result += this.function(i).value(values);
        }
        return result;
    }

    public String variableName(int param) {
        return this.function(0).variableName(param);
    }

    public String[] variableNames() {
        return this.function(0).variableNames();
    }

    public void addFunction(IFunction func) {
        this.functions.add(func);
        this.updateFunction();
    }

    public void removeFunction(IFunction func) {
        this.functions.remove(func);
        this.updateFunction();
    }

    public void removeAllFunctions() {
        this.functions.clear();
        this.updateFunction();
    }

    public IFunction function(int index) {
        return (IFunction)this.functions.get(index);
    }

    public int indexOfFunction(IFunction function) {
        return this.functions.indexOf(function);
    }

    public int nFunctions() {
        return this.functions.size();
    }

    public boolean containsFunction(IFunction function) {
        return this.functions.contains(function);
    }
}

