/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import hep.aida.ref.jel.JELLibraryFactory;
import java.util.StringTokenizer;

public class JELCompiledExpression {
    private String expression;
    private String parsedExpression;
    private int dim;
    private int nPar;
    private String[] parNames;
    private CompiledExpression compExpression;
    private ValueProvider pro;
    private Object[] context;
    private Resolver res;

    public JELCompiledExpression(int dim, int nPar, String expr, String[] pNames) {
        this.dim = dim;
        this.nPar = nPar;
        this.expression = expr;
        this.setParameterNames(pNames);
        this.parse();
        this.compile();
    }

    public void setParameterNames(String[] pNames) {
        if (pNames == null) {
            throw new IllegalArgumentException("Can not set parameter names to a null");
        }
        if (this.nPar != pNames.length) {
            throw new IllegalArgumentException("Number of parameters (" + this.nPar + ") is different from number of supplied parameter names (" + pNames.length + ")");
        }
        this.parNames = new String[pNames.length];
        for (int i = 0; i < pNames.length; ++i) {
            this.parNames[i] = pNames[i];
        }
    }

    public void parse() {
        this.parsedExpression = "";
        StringTokenizer st = new StringTokenizer(this.expression, "[]");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.toLowerCase().endsWith("x")) {
                this.parsedExpression = this.parsedExpression + token.substring(0, token.length() - 1) + "x" + st.nextToken();
                continue;
            }
            this.parsedExpression = this.parsedExpression + token;
        }
    }

    private void compile() {
        this.pro = new ValueProvider(this.dim, this.nPar);
        this.context = new Object[]{this.pro};
        this.res = new Resolver();
        this.compExpression = JELLibraryFactory.compile(this.res, this.pro.getClass(), this.parsedExpression, Double.TYPE);
    }

    public double evaluate(double[] var, double[] par) {
        this.pro.setVar(var);
        this.pro.setPar(par);
        double num = 0.0;
        try {
            num = this.compExpression.evaluate_double(this.context);
        }
        catch (Throwable t) {
            throw new RuntimeException("Runtime JEL Evaluation Problems!", t);
        }
        return num;
    }

    public int parseInt(String name) {
        return Integer.parseInt(name.substring(4, name.length() - 3));
    }

    public class ValueProvider {
        private double[] var;
        private double[] par;

        public ValueProvider(int dim, int nPar) {
            this.var = new double[dim];
            this.par = new double[nPar];
        }

        public void setVar(double[] v) {
            this.var = v;
        }

        public void setPar(double[] p) {
            this.par = p;
        }

        public double getDoubleProperty(int i) {
            if (i < JELCompiledExpression.this.dim) {
                return this.var[i];
            }
            if (i >= JELCompiledExpression.this.dim) {
                return this.par[i - JELCompiledExpression.this.dim];
            }
            if (i < 0 || i > JELCompiledExpression.this.dim + this.par.length) {
                throw new IllegalArgumentException("Wrong argument number: " + i + ", dimension = " + JELCompiledExpression.this.dim + ", N parameters = " + this.par.length);
            }
            return 0.0;
        }
    }

    public class Resolver
    extends DVMap {
        public String getTypeName(String name) {
            int i;
            for (i = 0; i < JELCompiledExpression.this.dim; ++i) {
                if (!name.equals("x" + i)) continue;
                return "Double";
            }
            for (i = 0; i < JELCompiledExpression.this.nPar; ++i) {
                if (!name.equals(JELCompiledExpression.this.parNames[i])) continue;
                return "Double";
            }
            return null;
        }

        public Object translate(String name) {
            int i;
            int n = -1;
            boolean offset = false;
            for (i = 0; i < JELCompiledExpression.this.dim; ++i) {
                if (!name.equals("x" + i)) continue;
                return new Integer(i);
            }
            for (i = 0; i < JELCompiledExpression.this.nPar; ++i) {
                if (!name.equals(JELCompiledExpression.this.parNames[i])) continue;
                return new Integer(i + JELCompiledExpression.this.dim);
            }
            return new Integer(n);
        }
    }
}

