/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.net;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.bounce.FormLayout;

public class DefaultAuthenticator
extends Authenticator {
    protected String TITLE = "Enter Username and Password";
    protected String DESCRIPTION = "Please provide your username and password.";
    protected String USERNAME = "Username:";
    protected String PASSWORD = "Password:";
    protected String HOST = "Site:";
    protected String REALM = "Realm:";
    protected String OK_BUTTON = "OK";
    protected String CANCEL_BUTTON = "Cancel";
    private JDialog dialog = null;
    private boolean okPressed = false;
    private JFrame parent = null;
    private JPasswordField passwordField = null;
    private JTextField usernameField = null;
    private JLabel hostField = null;
    private JLabel realmField = null;

    public DefaultAuthenticator(JFrame parent) {
        this.parent = parent;
    }

    private JDialog getDialog() {
        if (this.dialog == null) {
            Dimension size = new Dimension(350, 210);
            this.dialog = new JDialog(this.parent);
            this.dialog.setTitle(this.TITLE);
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
            JPanel panel = new JPanel(new FormLayout(5, 5));
            panel.setBorder(new EmptyBorder(10, 10, 10, 10));
            JLabel description = new JLabel(this.DESCRIPTION);
            description.setFont(description.getFont().deriveFont(0));
            panel.add((Component)description, FormLayout.FULL_FILL);
            panel.add(Box.createVerticalStrut(10), FormLayout.FULL_FILL);
            panel.add((Component)new JLabel(this.HOST), FormLayout.LEFT);
            this.hostField = new JLabel();
            this.hostField.setFont(this.hostField.getFont().deriveFont(0));
            panel.add((Component)this.hostField, FormLayout.RIGHT_FILL);
            panel.add((Component)new JLabel(this.REALM), FormLayout.LEFT);
            this.realmField = new JLabel();
            this.realmField.setFont(this.realmField.getFont().deriveFont(0));
            panel.add((Component)this.realmField, FormLayout.RIGHT_FILL);
            panel.add((Component)new JLabel(this.USERNAME), FormLayout.LEFT);
            this.usernameField = new JTextField();
            panel.add((Component)this.usernameField, FormLayout.RIGHT_FILL);
            panel.add((Component)new JLabel(this.PASSWORD), FormLayout.LEFT);
            this.passwordField = new JPasswordField();
            panel.add((Component)this.passwordField, FormLayout.RIGHT_FILL);
            JButton cancelButton = new JButton(this.CANCEL_BUTTON);
            cancelButton.setMnemonic('C');
            cancelButton.setFont(cancelButton.getFont().deriveFont(0));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultAuthenticator.this.okPressed = false;
                    DefaultAuthenticator.this.dialog.setVisible(false);
                }
            });
            JButton okButton = new JButton(this.OK_BUTTON);
            okButton.setMnemonic('O');
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultAuthenticator.this.okPressed = true;
                    DefaultAuthenticator.this.dialog.setVisible(false);
                }
            });
            this.dialog.getRootPane().setDefaultButton(okButton);
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 0, 0));
            buttonPanel.setBorder(new EmptyBorder(10, 0, 3, 0));
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            JPanel main = new JPanel(new BorderLayout());
            main.add((Component)panel, "Center");
            main.add((Component)buttonPanel, "South");
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DefaultAuthenticator.this.okPressed = false;
                    DefaultAuthenticator.this.dialog.setVisible(false);
                }
            });
            this.dialog.setContentPane(main);
            this.dialog.setDefaultCloseOperation(1);
            this.dialog.setSize(size);
        }
        return this.dialog;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        JDialog dialog = this.getDialog();
        this.passwordField.setText("");
        this.usernameField.setText("");
        this.hostField.setText(this.getRequestingHost());
        this.realmField.setText(this.getRequestingPrompt());
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
        if (this.okPressed) {
            return new PasswordAuthentication(this.usernameField.getText(), this.passwordField.getPassword());
        }
        return null;
    }
}

