/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.util.graph;

import java.io.File;
import java.io.IOException;
import org.encog.util.file.FileUtil;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.SaveImageDialog;
import org.encog.workbench.util.graph.DocumentPDF;
import org.encog.workbench.util.graph.DocumentSVG;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class EncogChartPanel
extends ChartPanel {
    public EncogChartPanel(JFreeChart chart) {
        super(chart);
    }

    public EncogChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, properties, save, print, zoom, tooltips);
    }

    public EncogChartPanel(JFreeChart chart, boolean useBuffer) {
        super(chart, useBuffer);
    }

    public EncogChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean copy, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, copy, save, print, zoom, tooltips);
    }

    public EncogChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
    }

    public void doSaveAs() throws IOException {
        SaveImageDialog dialog = new SaveImageDialog(EncogWorkBench.getInstance().getMainWindow());
        dialog.getImageWidth().setValue(640);
        dialog.getImageHeight().setValue(480);
        if (dialog.process()) {
            File filename = new File(dialog.getTargetFile().getValue());
            int width = dialog.getImageWidth().getValue();
            int height = dialog.getImageHeight().getValue();
            switch (dialog.getFileType().getSelectedIndex()) {
                case 0: {
                    filename = new File(FileUtil.forceExtension(filename.toString(), "png"));
                    ChartUtilities.saveChartAsPNG((File)filename, (JFreeChart)this.getChart(), (int)width, (int)height);
                    break;
                }
                case 1: {
                    filename = new File(FileUtil.forceExtension(filename.toString(), "jpg"));
                    ChartUtilities.saveChartAsPNG((File)filename, (JFreeChart)this.getChart(), (int)width, (int)height);
                    break;
                }
                case 2: {
                    filename = new File(FileUtil.forceExtension(filename.toString(), "pdf"));
                    DocumentPDF.savePDF(filename, this.getChart(), width, height);
                    break;
                }
                case 3: {
                    filename = new File(FileUtil.forceExtension(filename.toString(), "svg"));
                    DocumentSVG.saveSVG(filename, this.getChart(), width, height);
                }
            }
        }
    }
}

