/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.structure;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.encog.ml.MLMethod;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.neat.NEATNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.visualize.structure.DrawnConnection;
import org.encog.workbench.tabs.visualize.structure.DrawnNeuron;
import org.encog.workbench.tabs.visualize.structure.DrawnNeuronType;
import org.encog.workbench.tabs.visualize.structure.LegendPanel;

public class StructureTab
extends EncogCommonTab {
    private static final long serialVersionUID = 1L;
    private VisualizationViewer<DrawnNeuron, DrawnConnection> vv;

    public StructureTab(MLMethod method) {
        super((ProjectFile)null);
        Graph<DrawnNeuron, DrawnConnection> g = null;
        if (method instanceof BasicNetwork) {
            BasicNetwork network = (BasicNetwork)method;
            g = this.buildGraph(network.getStructure().getFlat());
        } else if (method instanceof NEATNetwork) {
            NEATNetwork neat = (NEATNetwork)method;
            g = this.buildGraph(neat);
        }
        if (g == null) {
            throw new WorkBenchError("Can't visualize network: " + method.getClass().getSimpleName());
        }
        Function<DrawnNeuron, Point2D> staticTranformer = new Function<DrawnNeuron, Point2D>(){

            public Point2D apply(DrawnNeuron n) {
                int x = (int)(n.getX() * 600.0);
                int y = (int)(n.getY() * 300.0);
                Point result = new Point(x + 32, y);
                return result;
            }
        };
        Function<DrawnNeuron, Paint> vertexPaint = new Function<DrawnNeuron, Paint>(){

            public Paint apply(DrawnNeuron neuron) {
                switch (neuron.getType()) {
                    case Bias: {
                        return Color.yellow;
                    }
                    case Input: {
                        return Color.white;
                    }
                    case Output: {
                        return Color.green;
                    }
                    case Context: {
                        return Color.cyan;
                    }
                }
                return Color.red;
            }
        };
        Function<DrawnConnection, Paint> edgePaint = new Function<DrawnConnection, Paint>(){

            public Paint apply(DrawnConnection connection) {
                if (connection.isContext()) {
                    return Color.lightGray;
                }
                return Color.black;
            }
        };
        StaticLayout layout = new StaticLayout(g, (Function)staticTranformer, new Dimension(5000, 5000));
        Dimension preferredSize = new Dimension(400, 400);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel((Layout)layout, preferredSize);
        this.vv = new VisualizationViewer((VisualizationModel)visualizationModel);
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv.getRenderContext().setVertexLabelTransformer((Function)new ToStringLabeller());
        this.vv.getRenderContext().setVertexFillPaintTransformer((Function)vertexPaint);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Function)edgePaint);
        this.vv.getRenderContext().setArrowDrawPaintTransformer((Function)edgePaint);
        this.vv.getRenderContext().setArrowFillPaintTransformer((Function)edgePaint);
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        this.vv.setVertexToolTipTransformer((Function)new Function<DrawnNeuron, String>(){

            public String apply(DrawnNeuron edge) {
                return edge.getToolTip();
            }
        });
        this.vv.setEdgeToolTipTransformer((Function)new Function<DrawnConnection, String>(){

            public String apply(DrawnConnection edge) {
                return edge.getToolTip();
            }
        });
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)StructureTab.this.vv, 1.1f, StructureTab.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)StructureTab.this.vv, 0.9090909f, StructureTab.this.vv.getCenter());
            }
        });
        JButton reset = new JButton("reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureTab.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                StructureTab.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
            }
        });
        JPanel controls = new JPanel();
        controls.setLayout(new FlowLayout(0));
        controls.add(plus);
        controls.add(minus);
        controls.add(reset);
        Border border = BorderFactory.createEtchedBorder();
        controls.setBorder(border);
        this.add((Component)controls, "North");
        this.add((Component)new LegendPanel(false), "South");
    }

    private Graph<DrawnNeuron, DrawnConnection> buildGraph(NEATNetwork neat) {
        boolean inputCount = true;
        boolean outputCount = true;
        boolean hiddenCount = true;
        boolean biasCount = true;
        return null;
    }

    public Graph<DrawnNeuron, DrawnConnection> buildGraph(FlatNetwork flat) {
        int inputCount = 1;
        int outputCount = 1;
        int hiddenCount = 1;
        int biasCount = 1;
        int contextCount = 1;
        int layerCount = flat.getLayerCounts().length;
        ArrayList<DrawnNeuron> neurons = new ArrayList<DrawnNeuron>();
        SparseMultigraph result = new SparseMultigraph();
        ArrayList connections = new ArrayList();
        double layerSize = 1.0 / (double)layerCount;
        boolean neuronNumber = true;
        int currentLayer = 0;
        while (currentLayer < layerCount) {
            ArrayList<DrawnNeuron> lastFedNeurons = new ArrayList<DrawnNeuron>();
            double x = (double)(layerCount - currentLayer - 1) / (double)layerCount;
            int neuronCount = flat.getLayerCounts()[currentLayer];
            int feedCount = flat.getLayerFeedCounts()[currentLayer];
            int currentNeuron = 0;
            while (currentNeuron < neuronCount) {
                DrawnNeuronType type;
                double xOffset = 0.0;
                String name = "?";
                if (currentNeuron < feedCount) {
                    if (currentLayer == 0) {
                        type = DrawnNeuronType.Output;
                        name = "O" + outputCount++;
                    } else if (currentLayer == layerCount - 1) {
                        type = DrawnNeuronType.Input;
                        name = "I" + inputCount++;
                    } else {
                        type = DrawnNeuronType.Hidden;
                        name = "H" + hiddenCount++;
                    }
                } else if (currentNeuron == feedCount) {
                    type = DrawnNeuronType.Bias;
                    name = "B" + biasCount++;
                } else {
                    type = DrawnNeuronType.Context;
                    name = "C" + contextCount++;
                    xOffset = layerSize / 4.0;
                }
                double y = (double)currentNeuron / (double)neuronCount;
                double margin = (double)(neuronCount - 1) / (double)neuronCount;
                margin = 1.0 - margin;
                DrawnNeuron neuron = new DrawnNeuron(type, name);
                neuron.setX(x + xOffset);
                neuron.setY(y + (margin /= 2.0));
                neurons.add(neuron);
                if (neuron.getType() == DrawnNeuronType.Hidden || neuron.getType() == DrawnNeuronType.Output) {
                    lastFedNeurons.add(neuron);
                }
                int toNeuron = 0;
                int count = connections.size();
                for (DrawnNeuron connectTo : connections) {
                    int weightIndex = flat.getLayerIndex()[currentLayer] + toNeuron * count + currentNeuron;
                    double w = 0.0;
                    DrawnConnection connection = new DrawnConnection(neuron, connectTo, w);
                    neuron.getOutbound().add(connection);
                    neuron.getInbound().add(connection);
                    ++toNeuron;
                }
                ++currentNeuron;
            }
            connections = lastFedNeurons;
            ++currentLayer;
        }
        for (DrawnNeuron neuron : neurons) {
            result.addVertex((Object)neuron);
            for (DrawnConnection connection : neuron.getOutbound()) {
                result.addEdge((Object)connection, (Object)connection.getFrom(), (Object)connection.getTo(), EdgeType.DIRECTED);
            }
        }
        currentLayer = 0;
        while (currentLayer < layerCount) {
            if (flat.getContextTargetSize()[currentLayer] > 0) {
                int count = flat.getContextTargetSize()[currentLayer];
                int offset = flat.getContextTargetOffset()[currentLayer];
                int source = flat.getLayerIndex()[currentLayer];
                int i = 0;
                while (i < count) {
                    DrawnNeuron n1 = (DrawnNeuron)neurons.get(source + i);
                    DrawnNeuron n2 = (DrawnNeuron)neurons.get(offset + i);
                    DrawnConnection connection = new DrawnConnection(n1, n2, 0.0);
                    result.addEdge((Object)connection, (Object)connection.getFrom(), (Object)connection.getTo(), EdgeType.DIRECTED);
                    connection.setContext(true);
                    ++i;
                }
            }
            ++currentLayer;
        }
        return result;
    }

    @Override
    public String getName() {
        return "Structure: " + this.getEncogObject().getName();
    }
}

