/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.structure;

import org.encog.util.Format;
import org.encog.workbench.tabs.visualize.structure.DrawnNeuron;

public class DrawnConnection {
    private final DrawnNeuron from;
    private final DrawnNeuron to;
    private final double weight;
    private boolean context;

    public DrawnConnection(DrawnNeuron from, DrawnNeuron to, double weight) {
        this.from = from;
        this.to = to;
        this.weight = weight;
        this.context = false;
    }

    public DrawnNeuron getFrom() {
        return this.from;
    }

    public DrawnNeuron getTo() {
        return this.to;
    }

    public double getWeight() {
        return this.weight;
    }

    public String getToolTip() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.from.getName());
        builder.append("->");
        builder.append(this.to.getName());
        builder.append(" : ");
        builder.append(Format.formatDouble(this.weight, 4));
        return builder.toString();
    }

    public boolean isContext() {
        return this.context;
    }

    public void setContext(boolean context) {
        this.context = context;
    }
}

