/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.scatter;

import org.encog.workbench.tabs.visualize.scatter.ScatterFile;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;

public class ScatterXY
extends AbstractXYDataset
implements XYDataset,
DomainInfo,
RangeInfo {
    private ScatterFile scatterFile;
    private Number domainMin;
    private Number domainMax;
    private Number rangeMin;
    private Number rangeMax;
    private Range domainRange;
    private Range range;
    private int xIndex;
    private int yIndex;

    public ScatterXY(ScatterFile scatterFile, int xIndex, int yIndex) {
        this.scatterFile = scatterFile;
        this.xIndex = xIndex;
        this.yIndex = yIndex;
        double minX = scatterFile.findMin(this.xIndex);
        double maxX = scatterFile.findMax(this.xIndex);
        double minY = scatterFile.findMin(this.yIndex);
        double maxY = scatterFile.findMax(this.yIndex);
        this.domainMin = new Double(minX);
        this.domainMax = new Double(maxX);
        this.domainRange = new Range(minX, maxX);
        this.rangeMin = new Double(minY);
        this.rangeMax = new Double(maxY);
        this.range = new Range(minY, maxY);
    }

    public Number getX(int series, int item) {
        return this.scatterFile.getSeries(series).get(item)[this.xIndex];
    }

    public Number getY(int series, int item) {
        return this.scatterFile.getSeries(series).get(item)[this.yIndex];
    }

    public int getSeriesCount() {
        return this.scatterFile.getSeriesCount();
    }

    public Comparable getSeriesKey(int series) {
        return (Comparable)((Object)this.scatterFile.getSeries().get(series));
    }

    public int getItemCount(int series) {
        int i = this.scatterFile.getSeries(series).size();
        return i;
    }

    public double getDomainLowerBound() {
        return this.domainMin.doubleValue();
    }

    public double getDomainLowerBound(boolean includeInterval) {
        return this.domainMin.doubleValue();
    }

    public double getDomainUpperBound() {
        return this.domainMax.doubleValue();
    }

    public double getDomainUpperBound(boolean includeInterval) {
        return this.domainMax.doubleValue();
    }

    public Range getDomainBounds() {
        return this.domainRange;
    }

    public Range getDomainBounds(boolean includeInterval) {
        return this.domainRange;
    }

    public Range getDomainRange() {
        return this.domainRange;
    }

    public double getRangeLowerBound() {
        return this.rangeMin.doubleValue();
    }

    public double getRangeLowerBound(boolean includeInterval) {
        return this.rangeMin.doubleValue();
    }

    public double getRangeUpperBound() {
        return this.rangeMax.doubleValue();
    }

    public double getRangeUpperBound(boolean includeInterval) {
        return this.rangeMax.doubleValue();
    }

    public Range getRangeBounds(boolean includeInterval) {
        return this.range;
    }

    public Range getValueRange() {
        return this.range;
    }

    public Number getMinimumDomainValue() {
        return this.domainMin;
    }

    public Number getMaximumDomainValue() {
        return this.domainMax;
    }

    public Number getMinimumRangeValue() {
        return this.domainMin;
    }

    public Number getMaximumRangeValue() {
        return this.domainMax;
    }
}

