/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.scatter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.visualize.scatter.LegendPanel;
import org.encog.workbench.tabs.visualize.scatter.ScatterFile;
import org.encog.workbench.tabs.visualize.scatter.ScatterLabelPane;
import org.encog.workbench.tabs.visualize.scatter.ScatterXY;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class ScatterPlotTab
extends EncogCommonTab {
    private EncogAnalyst analyst;
    private ScatterFile file;
    private XYPlot samplePlot;
    public static Color[] COLORS = new Color[]{Color.red, Color.green, Color.blue, Color.black, Color.cyan, Color.magenta, Color.orange, Color.pink, Color.white, Color.yellow, Color.lightGray, Color.darkGray};

    public ScatterPlotTab(EncogAnalyst analyst, String className, List<String> axisList) {
        super((ProjectFile)null);
        this.analyst = analyst;
        this.file = new ScatterFile(this.analyst, className, axisList);
        if (axisList.size() <= 2) {
            this.add(this.createPanel(0, 1, true));
            return;
        }
        JPanel panel = new JPanel();
        int count = axisList.size();
        panel.setLayout(new GridLayout(count, count));
        int col = 0;
        while (col < count) {
            int row = 0;
            while (row < count) {
                if (col == row) {
                    panel.add(new ScatterLabelPane(axisList.get(row)));
                } else {
                    panel.add(this.createPanel(row, col, false));
                }
                ++row;
            }
            ++col;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        LegendPanel legend = new LegendPanel((LegendItemSource)this.samplePlot);
        this.add((Component)legend, "South");
    }

    private JPanel createPanel(int xIndex, int yIndex, boolean legend) {
        ScatterXY dataset = new ScatterXY(this.file, xIndex, yIndex);
        JFreeChart chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYDotRenderer renderer = new XYDotRenderer();
        renderer.setDotWidth(4);
        renderer.setDotHeight(4);
        if (this.file.isRegression()) {
            int per = 25;
            int r = 0;
            int b = 255;
            int i = 0;
            while (i < this.file.getSeriesCount()) {
                renderer.setSeriesPaint(i, (Paint)new Color(r, 0, b));
                r += per;
                b -= per;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.file.getSeriesCount()) {
                renderer.setSeriesPaint(i, (Paint)COLORS[i % COLORS.length]);
                ++i;
            }
        }
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        plot.getRangeAxis().setInverted(false);
        ChartPanel result = new ChartPanel(chart);
        result.setBorder(BorderFactory.createLineBorder(Color.black));
        if (this.samplePlot == null) {
            this.samplePlot = plot;
        }
        return result;
    }

    @Override
    public String getName() {
        return "Scatter Plot";
    }
}

