/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.scatter;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.prop.ScriptProperties;
import org.encog.util.Format;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.workbench.WorkBenchError;

public class ScatterFile {
    private final EncogAnalyst analyst;
    private final Map<String, Integer> axisMapping = new HashMap<String, Integer>();
    private int targetIndex;
    private Map<String, List<double[]>> data = new HashMap<String, List<double[]>>();
    private DataField targetField;
    private List<String> axis;
    private List<String> series = new ArrayList<String>();
    private double regressionSeriesSize;
    private double[] regressionSeriesPoint;

    public ScatterFile(EncogAnalyst analyst, String target, List<String> axis) {
        this.analyst = analyst;
        this.axis = axis;
        this.buildMappings(target, axis);
        this.readRawFile();
    }

    private boolean isAxis(String name, List<String> axis) {
        for (String field : axis) {
            if (!field.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void buildMappings(String target, List<String> axis) {
        DataField[] fields = this.analyst.getScript().getFields();
        this.targetField = this.analyst.getScript().findDataField(target);
        if (this.targetField == null) {
            throw new WorkBenchError("Can't find target field: " + target);
        }
        this.targetIndex = this.analyst.getScript().findDataFieldIndex(this.targetField);
        if (this.targetField.isClass()) {
            for (AnalystClassItem cls : this.targetField.getClassMembers()) {
                this.series.add(cls.getName().toLowerCase());
            }
        } else {
            this.regressionSeriesPoint = new double[10];
            double totalWidth = this.targetField.getMax() - this.targetField.getMin();
            this.regressionSeriesSize = totalWidth / 12.0;
            double current = this.targetField.getMin() + this.regressionSeriesSize;
            int i = 0;
            while (i < 10) {
                StringBuilder s = new StringBuilder();
                s.append(Format.formatDouble(current, 1));
                this.data.put(s.toString().toLowerCase(), new ArrayList());
                this.series.add(s.toString());
                this.regressionSeriesPoint[i] = current;
                current += this.regressionSeriesSize;
                ++i;
            }
        }
        int index = 0;
        while (index < fields.length) {
            DataField field = fields[index];
            if (this.isAxis(field.getName(), axis)) {
                this.axisMapping.put(field.getName().toLowerCase(), index);
            }
            ++index;
        }
    }

    private void readRawFile() {
        ScriptProperties prop = this.analyst.getScript().getProperties();
        String sourceID = prop.getPropertyString("HEADER:DATASOURCE_rawFile");
        File sourceFile = this.analyst.getScript().resolveFilename(sourceID);
        CSVFormat inputFormat = this.analyst.getScript().determineFormat();
        boolean headers = this.analyst.getScript().expectInputHeaders(sourceID);
        int rowSize = this.axisMapping.size();
        boolean regression = !this.targetField.isClass();
        ReadCSV csv = new ReadCSV(sourceFile.toString(), headers, inputFormat);
        while (csv.next()) {
            List<Object> dataList;
            double[] row = new double[rowSize];
            String cls = "?";
            if (regression) {
                double d = csv.getDouble(this.targetIndex);
                int i = this.series.size() - 1;
                while (i >= 0) {
                    if (d > this.regressionSeriesPoint[i]) {
                        cls = this.series.get(i);
                        break;
                    }
                    --i;
                }
            } else {
                cls = csv.get(this.targetIndex);
                cls = cls.toLowerCase();
            }
            if (this.data.containsKey(cls)) {
                dataList = this.data.get(cls);
            } else {
                dataList = new ArrayList();
                this.data.put(cls, dataList);
            }
            int rowIndex = 0;
            for (String key : this.axis) {
                int index = this.axisMapping.get(key);
                double d = csv.getDouble(index);
                row[rowIndex++] = d;
            }
            dataList.add(row);
        }
        csv.close();
    }

    public Map<String, Integer> getAxisMapping() {
        return this.axisMapping;
    }

    public List<String> getAxis() {
        return this.axis;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public DataField getTargetField() {
        return this.targetField;
    }

    public List<double[]> getSeries(String name) {
        return this.data.get(name.toLowerCase());
    }

    public List<double[]> getSeries(int index) {
        String name = this.series.get(index).toLowerCase();
        return this.data.get(name.toLowerCase());
    }

    public double findMin(int index) {
        double result = Double.POSITIVE_INFINITY;
        for (String key : this.data.keySet()) {
            List<double[]> list = this.data.get(key);
            for (double[] array : list) {
                result = Math.min(result, array[index]);
            }
        }
        return result;
    }

    public double findMax(int index) {
        double result = Double.NEGATIVE_INFINITY;
        for (String key : this.data.keySet()) {
            List<double[]> list = this.data.get(key);
            for (double[] array : list) {
                result = Math.max(result, array[index]);
            }
        }
        return result;
    }

    public int getSeriesCount() {
        return this.series.size();
    }

    public List<String> getSeries() {
        return this.series;
    }

    public boolean isRegression() {
        return !this.targetField.isClass();
    }
}

