/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.population.epl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.util.Format;
import org.encog.workbench.WorkbenchFonts;

public class EPLPopulationInfo
extends JPanel {
    private PrgPopulation population;

    public EPLPopulationInfo(PrgPopulation thePopulation) {
        this.population = thePopulation;
    }

    @Override
    public void paint(Graphics g) {
        double score;
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setFont(WorkbenchFonts.getTitle2Font());
        FontMetrics fm = g.getFontMetrics();
        int y = fm.getHeight();
        g.drawString("Maximum Population Count:", 20, y);
        g.drawString("Input Count:", 300, y);
        g.drawString("Current Population Count:", 20, y += fm.getHeight());
        g.drawString("Output Count:", 300, y);
        g.drawString("Species Count:", 20, y += fm.getHeight());
        g.drawString("Max Size:", 20, y += fm.getHeight());
        g.drawString("Best Genome Score:", 20, y += fm.getHeight());
        int populationSize = this.population.flatten().size();
        String bestScore = "n/a";
        if (this.population.getBestGenome() != null && !Double.isInfinite(score = this.population.getBestGenome().getScore()) && !Double.isNaN(score)) {
            bestScore = Format.formatDouble(this.population.getBestGenome().getScore(), 2);
        }
        y = fm.getHeight();
        g.setFont(WorkbenchFonts.getTextFont());
        g.drawString(Format.formatInteger(this.population.getPopulationSize()), 200, y);
        g.drawString(Format.formatInteger(this.population.getContext().getDefinedVariables().size()), 480, y);
        g.drawString(Format.formatInteger(populationSize), 200, y += fm.getHeight());
        g.drawString(Format.formatInteger(1), 480, y);
        g.drawString(Format.formatInteger(this.population.getSpecies().size()), 200, y += fm.getHeight());
        g.drawString(Format.formatInteger(this.population.getMaxIndividualSize()), 200, y += fm.getHeight());
        g.drawString(bestScore, 200, y += fm.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(620, 100);
    }
}

