/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.files;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.models.BufferedDataSetTableModel;
import org.encog.workbench.process.ImportExport;
import org.encog.workbench.tabs.files.BasicFileTab;
import org.encog.workbench.tabs.visualize.grid.VisualizeGridTab;

public class BinaryDataTab
extends BasicFileTab
implements ActionListener {
    private BufferedDataSetTableModel model;
    private JToolBar toolbar;
    private JTable table;
    private JButton addInputColumn;
    private JButton delColumn;
    private JButton addIdealColumn;
    private JButton addRow;
    private JButton delRow;
    private JButton export;
    private JButton visualize;
    private BufferedMLDataSet data;

    public BinaryDataTab(ProjectFile file) {
        super(file);
        this.data = new BufferedMLDataSet(file.getFile());
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.addInputColumn = new JButton("Add Input Column");
        this.toolbar.add(this.addInputColumn);
        this.delColumn = new JButton("Delete Column");
        this.toolbar.add(this.delColumn);
        this.addIdealColumn = new JButton("Add Ideal Column");
        this.toolbar.add(this.addIdealColumn);
        this.addRow = new JButton("Add Row");
        this.toolbar.add(this.addRow);
        this.delRow = new JButton("Delete Row");
        this.toolbar.add(this.delRow);
        this.export = new JButton("Export");
        this.toolbar.add(this.export);
        this.visualize = new JButton("Visualize");
        this.toolbar.add(this.visualize);
        this.addInputColumn.addActionListener(this);
        this.delColumn.addActionListener(this);
        this.addIdealColumn.addActionListener(this);
        this.addRow.addActionListener(this);
        this.delRow.addActionListener(this);
        this.export.addActionListener(this);
        this.add((Component)this.toolbar, "First");
        this.model = new BufferedDataSetTableModel(this.getData());
        this.table = new JTable(this.model);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.setAutoResizeMode(0);
        this.visualize.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        try {
            int row = this.table.getSelectedRow();
            int col = this.table.getSelectedColumn();
            if (action.getSource() == this.addInputColumn) {
                this.model.addInputColumn();
            } else if (action.getSource() == this.delColumn) {
                if (col == -1) {
                    JOptionPane.showMessageDialog(this, "Please move to the column you wish to delete.", "Error", 0);
                } else if (col < this.getData().getInputSize() && this.getData().getInputSize() <= 1) {
                    JOptionPane.showMessageDialog(this, "There must be at least one input column.", "Error", 0);
                } else {
                    this.model.delColumn(col);
                }
            } else if (action.getSource() == this.addIdealColumn) {
                this.model.addIdealColumn();
            } else if (action.getSource() == this.addRow) {
                this.model.addRow(row);
            } else if (action.getSource() == this.delRow) {
                if (row == -1) {
                    JOptionPane.showMessageDialog(this, "Please move to the row you wish to delete.", "Error", 0);
                } else {
                    this.model.delRow(row);
                }
            } else if (action.getSource() == this.export) {
                Object[] list = new Object[]{this.getData().getFile(), null};
                ImportExport.performBin2External(this.getData().getFile(), null);
            } else if (action.getSource() == this.visualize) {
                this.performVisualize();
            }
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }

    @Override
    public boolean close() throws IOException {
        boolean result = super.close();
        if (this.data != null) {
            this.data.close();
            this.data = null;
        }
        return result;
    }

    @Override
    public void dispose() {
        if (this.data != null) {
            this.data.close();
            this.data = null;
        }
        super.dispose();
    }

    public BufferedMLDataSet getData() {
        return this.data;
    }

    public void performVisualize() {
        VisualizeGridTab tab = new VisualizeGridTab(this.data);
        EncogWorkBench.getInstance().getMainWindow().getTabManager().openTab(tab);
    }
}

