/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.models.population.epl;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.encog.ml.prg.EncogProgram;
import org.encog.parse.expression.common.RenderCommonExpression;
import org.encog.util.Format;
import org.encog.workbench.tabs.population.epl.EPLPopulationTab;

public class EPLPopulationModel
implements TableModel {
    private EPLPopulationTab owner;
    public static String[] COLUMNS = new String[]{"#", "Length", "Score", "Adj. Score", "Species", "Expression"};

    public EPLPopulationModel(EPLPopulationTab population) {
        this.owner = population;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.owner.getList().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        EncogProgram genome = (EncogProgram)this.owner.getList().get(rowIndex);
        RenderCommonExpression render = new RenderCommonExpression();
        switch (columnIndex) {
            case 0: {
                return "" + rowIndex;
            }
            case 1: {
                return Format.formatInteger(genome.size());
            }
            case 2: {
                if (Double.isNaN(genome.getScore()) || Double.isInfinite(genome.getScore())) {
                    return "NaN";
                }
                return Format.formatDouble(genome.getScore(), 4);
            }
            case 3: {
                if (Double.isNaN(genome.getAdjustedScore()) || Double.isInfinite(genome.getAdjustedScore())) {
                    return "NaN";
                }
                return Format.formatDouble(genome.getAdjustedScore(), 4);
            }
            case 4: {
                int speciesIndex = this.owner.getPopulation().getSpecies().indexOf(genome.getSpecies());
                String speciesName = "Unknown";
                if (speciesIndex >= 0) {
                    speciesName = "Species #" + (speciesIndex + 1);
                }
                return speciesName;
            }
            case 5: {
                return render.render(genome);
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

