/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.frames.document;

import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import org.encog.Encog;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.EncogDocumentFrame;
import org.encog.workbench.process.CreateNewFile;
import org.encog.workbench.process.ImportExport;
import org.encog.workbench.process.TrainBasicNetwork;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.SupportsClipboard;
import org.encog.workbench.tabs.ValidationChart;

public class EncogMenus {
    public static final String FILE_CHANGE_DIR = "Change Directory/Open Project";
    public static final String FILE_NEW_PROJECT = "New Project...";
    public static final String FILE_NEW_FILE = "New File...";
    public static final String FILE_IMPORT = "Import File...";
    public static final String FILE_SAVE = "Save";
    public static final String FILE_QUIT = "Quit...";
    public static final String EDIT_CUT = "Cut";
    public static final String EDIT_COPY = "Copy";
    public static final String EDIT_PASTE = "Paste";
    public static final String EDIT_SELECT_ALL = "Select All";
    public static final String EDIT_CONFIG = "Config...";
    public static final String EDIT_FIND = "Find...";
    public static final String VIEW_RBF = "Chart RBF...";
    public static final String TOOLS_TRAIN = "Train...";
    public static final String TOOLS_GENERATE_TRAINING = "Generate Training Data...";
    public static final String TOOLS_EVALUATE = "Evaluate Method...";
    public static final String TOOLS_BENCHMARK = "Benchmark Encog...";
    public static final String TOOLS_VALIDATION_CHART = "Validation Chart...";
    public static final String TOOLS_BIN2EXTERNAL = "Convert Encog Binary to Other File...";
    public static final String TOOLS_EXTERNAL2BIN = "Convert Other File to Encog Binary...";
    public static final String TOOLS_PROBEN = "Proben1...";
    public static final String TOOLS_NOISE = "Generate Noise...";
    public static final String TOOLS_WIZARD = "Wizards...";
    public static final String HELP_ABOUT = "About Encog Workbench...";
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuEdit;
    private JMenu menuHelp;
    private JMenu menuTools;
    private JMenu menuView;
    private JMenuItem menuFileNew;
    private JMenuItem menuFileNewProject;
    private JMenuItem menuFileImport;
    private JMenuItem menuFileChangeDir;
    private JMenuItem menuFileSeve;
    private JMenuItem menuFileQuit;
    private JMenuItem menuEditCut;
    private JMenuItem menuEditCopy;
    private JMenuItem menuEditPaste;
    private JMenuItem menuEditSelectAll;
    private JMenuItem menuEditConfig;
    private JMenuItem menuEditFind;
    private JMenuItem menuViewRBF;
    private JMenuItem menuToolsTrain;
    private JMenuItem menuToolsGenerate;
    private JMenuItem menuToolsEvaluate;
    private JMenuItem menuToolsBenchmark;
    private JMenuItem menuToolsBrowse;
    private JMenuItem menuToolsValidation;
    private JMenuItem menuToolsBin2Ext;
    private JMenuItem menuToolsExt2Bin;
    private JMenuItem menuToolsProben;
    private JMenuItem menuToolsNoise;
    private JMenuItem menuToolsWizard;
    private JMenuItem menuHelpAbout;
    private EncogDocumentFrame owner;

    public EncogMenus(EncogDocumentFrame owner) {
        this.owner = owner;
    }

    void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuFileNewProject = this.menuFile.add(this.owner.addItem(this.menuFile, FILE_NEW_PROJECT, 0));
        this.menuFileChangeDir = this.menuFile.add(this.owner.addItem(this.menuFile, FILE_CHANGE_DIR, 67));
        this.menuFileNew = this.menuFile.add(this.owner.addItem(this.menuFile, FILE_NEW_FILE, 78));
        this.menuFileImport = this.menuFile.add(this.owner.addItem(this.menuFile, FILE_IMPORT, 73));
        this.menuFileSeve = this.menuFile.add(this.owner.addItem(this.menuFile, FILE_SAVE, 83));
        if (!Encog.isOSX()) {
            this.menuFile.addSeparator();
            this.menuFileQuit = this.menuFile.add(this.owner.addItem(this.menuFile, FILE_QUIT, 81));
        }
        this.menuFile.addActionListener(this.owner);
        this.menuBar.add(this.menuFile);
        this.menuEdit = new JMenu("Edit");
        this.menuEditCut = this.menuEdit.add(this.owner.addItem(this.menuEdit, EDIT_CUT, 88));
        this.menuEditCopy = this.menuEdit.add(this.owner.addItem(this.menuEdit, EDIT_COPY, 67));
        this.menuEditPaste = this.menuEdit.add(this.owner.addItem(this.menuEdit, EDIT_PASTE, 86));
        this.menuEditSelectAll = this.menuEdit.add(this.owner.addItem(this.menuEdit, EDIT_SELECT_ALL, 65));
        this.menuEdit.addSeparator();
        this.menuEditConfig = this.menuEdit.add(this.owner.addItem(this.menuEdit, EDIT_CONFIG, 0));
        this.menuEditFind = this.menuEdit.add(this.owner.addItem(this.menuEdit, EDIT_FIND, 70));
        this.menuBar.add(this.menuEdit);
        this.menuView = new JMenu("View");
        this.menuViewRBF = this.owner.addItem(this.menuView, VIEW_RBF, 0);
        this.menuBar.add(this.menuView);
        this.menuTools = new JMenu("Tools");
        this.menuToolsGenerate = this.owner.addItem(this.menuTools, TOOLS_GENERATE_TRAINING, 0);
        this.menuToolsTrain = this.owner.addItem(this.menuTools, TOOLS_TRAIN, 0);
        this.menuToolsBenchmark = this.owner.addItem(this.menuTools, TOOLS_BENCHMARK, 0);
        this.menuToolsEvaluate = this.owner.addItem(this.menuTools, TOOLS_EVALUATE, 0);
        this.menuToolsValidation = this.owner.addItem(this.menuTools, TOOLS_VALIDATION_CHART, 0);
        this.menuToolsBin2Ext = this.owner.addItem(this.menuTools, TOOLS_BIN2EXTERNAL, 0);
        this.menuToolsExt2Bin = this.owner.addItem(this.menuTools, TOOLS_EXTERNAL2BIN, 0);
        this.menuToolsProben = this.owner.addItem(this.menuTools, TOOLS_PROBEN, 0);
        this.menuToolsNoise = this.owner.addItem(this.menuTools, TOOLS_NOISE, 0);
        this.menuToolsWizard = this.owner.addItem(this.menuTools, TOOLS_WIZARD, 0);
        this.menuBar.add(this.menuTools);
        this.menuHelp = new JMenu("Help");
        this.menuHelpAbout = this.menuHelp.add(this.owner.addItem(this.menuHelp, HELP_ABOUT, 97));
        this.menuBar.add(this.menuHelp);
        this.owner.setJMenuBar(this.menuBar);
    }

    public void updateMenus() {
        boolean modal = this.owner.getTabManager().isModalTabOpen();
        boolean documentOpen = EncogWorkBench.getInstance().getProjectDirectory() != null;
        JTabbedPane tabs = this.owner.getTabManager().getDocumentTabs();
        EncogCommonTab currentTab = (EncogCommonTab)tabs.getSelectedComponent();
        boolean supportsClipboard = currentTab instanceof SupportsClipboard;
        this.menuFileNew.setEnabled(!modal && documentOpen);
        this.menuFileChangeDir.setEnabled(!modal);
        this.menuFileNewProject.setEnabled(!modal);
        if (!Encog.isOSX()) {
            this.menuFileQuit.setEnabled(true);
        }
        this.menuFileImport.setEnabled(!modal && documentOpen);
        this.menuFileSeve.setEnabled(!modal && documentOpen && currentTab != null);
        this.menuEditCut.setEnabled(!modal && supportsClipboard && documentOpen);
        this.menuEditCopy.setEnabled(!modal && supportsClipboard && documentOpen);
        this.menuEditPaste.setEnabled(!modal && supportsClipboard && documentOpen);
        this.menuEditSelectAll.setEnabled(!modal && supportsClipboard && documentOpen);
        this.menuEditConfig.setEnabled(!modal);
        this.menuViewRBF.setEnabled(!modal);
        this.menuToolsTrain.setEnabled(!modal && documentOpen);
        this.menuToolsGenerate.setEnabled(!modal && documentOpen);
        this.menuToolsEvaluate.setEnabled(!modal && documentOpen);
        this.menuToolsBenchmark.setEnabled(!modal);
        this.menuToolsValidation.setEnabled(!modal && documentOpen);
        this.menuToolsExt2Bin.setEnabled(!modal);
        this.menuToolsBin2Ext.setEnabled(!modal);
        this.menuToolsWizard.setEnabled(!modal && documentOpen);
        this.menuHelpAbout.setEnabled(!modal);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            EncogWorkBench.getInstance().getMainWindow().endWait();
            if (event.getActionCommand().equals(FILE_CHANGE_DIR)) {
                this.owner.getOperations().performFileChooseDirectory();
            } else if (event.getActionCommand().equals(FILE_NEW_PROJECT)) {
                this.owner.getOperations().performFileNewProject();
            } else if (event.getActionCommand().equals(FILE_NEW_FILE)) {
                CreateNewFile.performCreateFile();
            } else if (event.getActionCommand().equals(FILE_IMPORT)) {
                this.owner.getOperations().importFile();
            } else if (event.getActionCommand().equals(FILE_SAVE)) {
                this.owner.getOperations().performSave();
            } else if (event.getActionCommand().equals(FILE_QUIT)) {
                this.owner.getOperations().performQuit();
            } else if (event.getActionCommand().equals(EDIT_CUT)) {
                this.owner.getOperations().performEditCut();
            } else if (event.getActionCommand().equals(EDIT_COPY)) {
                this.owner.getOperations().performEditCopy();
            } else if (event.getActionCommand().equals(EDIT_PASTE)) {
                this.owner.getOperations().performEditPaste();
            } else if (event.getActionCommand().equals(EDIT_SELECT_ALL)) {
                this.owner.getOperations().performEditSelectAll();
            } else if (event.getActionCommand().equals(EDIT_CONFIG)) {
                this.owner.getOperations().performEditConfig();
            } else if (event.getActionCommand().equals(EDIT_FIND)) {
                this.owner.getOperations().performEditFind();
            } else if (event.getActionCommand().equals(HELP_ABOUT)) {
                this.owner.getOperations().performHelpAbout();
            } else if (event.getActionCommand().equals(TOOLS_BENCHMARK)) {
                this.owner.getOperations().performBenchmark();
            } else if (event.getActionCommand().equals(TOOLS_PROBEN)) {
                this.owner.getOperations().performProben();
            } else if (event.getActionCommand().equals(TOOLS_NOISE)) {
                this.owner.getOperations().performNoise();
            } else if (event.getActionCommand().equals(TOOLS_EVALUATE)) {
                this.owner.getOperations().performEvaluate();
            } else if (event.getActionCommand().equals(TOOLS_TRAIN)) {
                TrainBasicNetwork t = new TrainBasicNetwork(null, null);
                t.performTrain();
            } else if (event.getActionCommand().equals(TOOLS_VALIDATION_CHART)) {
                ValidationChart check = new ValidationChart();
                check.perform(EncogWorkBench.getInstance().getMainWindow());
            } else if (event.getActionCommand().equals(TOOLS_BIN2EXTERNAL)) {
                ImportExport.performBin2External();
            } else if (event.getActionCommand().equals(TOOLS_EXTERNAL2BIN)) {
                ImportExport.performExternal2Bin(null, null, null);
            } else if (event.getActionCommand().equals(VIEW_RBF)) {
                this.owner.getOperations().performRBF();
            } else if (event.getActionCommand().equals(TOOLS_GENERATE_TRAINING)) {
                this.owner.getOperations().performCreateTrainingData();
            } else if (event.getActionCommand().equals(TOOLS_WIZARD)) {
                this.owner.getOperations().performWizard();
            }
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }
}

