/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.editor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.encog.workbench.editor.ObjectEditorModel;

public class PropertyCollection {
    private ObjectEditorModel model;
    private Object data;
    private List<Field> fields = new ArrayList<Field>();
    private List<String> fieldNames = new ArrayList<String>();
    public static final String[] booleanValues = new String[]{"true", "false"};

    public PropertyCollection(Object data) {
        this.data = data;
        this.model = new ObjectEditorModel(this);
    }

    public int size() {
        return this.fields.size();
    }

    public String getFieldName(int field) {
        return this.fieldNames.get(field);
    }

    public Field getField(int field) {
        return this.fields.get(field);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
        this.fields.clear();
        this.fieldNames.clear();
        if (data != null) {
            Field[] f = data.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                Class<?> c;
                if ((f[i].getModifiers() & 0x10) == 0 && this.isDirectEditableType(c = f[i].getType())) {
                    f[i].setAccessible(true);
                    this.fields.add(f[i]);
                    this.fieldNames.add(f[i].getName());
                }
                ++i;
            }
        }
        this.model.updateListeners();
    }

    private boolean isDirectEditableType(Class<?> c) {
        return c == Integer.TYPE || c == Short.TYPE || c == Character.TYPE || c == Long.TYPE || c == Byte.TYPE || c == String.class || c == Boolean.TYPE;
    }

    public ObjectEditorModel getModel() {
        return this.model;
    }
}

