/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.wizard.analyst;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.wizard.PredictionType;
import org.encog.app.analyst.wizard.SourceElement;
import org.encog.app.generate.TargetLanguage;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.BuildingListField;
import org.encog.workbench.dialogs.common.BuildingListListener;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.dialogs.common.TextField;
import org.encog.workbench.dialogs.wizard.analyst.IndicatorSourceDialog;

public class RealTimeAnalystWizardDialog
extends EncogPropertiesDialog
implements BuildingListListener {
    private BuildingListField sourceData;
    private final TextField baseName;
    private final ComboBoxField target;
    private final TextField predictionField;
    private final ComboBoxField prediction;
    private final IntegerField forwardWindow;
    private final IntegerField backwardWindow;
    private final List<String> methods = new ArrayList<String>();

    public RealTimeAnalystWizardDialog(File existingFile) {
        super(EncogWorkBench.getInstance().getMainWindow());
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("Ninjatrader 7");
        targets.add("Metatrader 4 (MQL4)");
        ArrayList<String> predictionList = new ArrayList<String>();
        predictionList.add("Max Value (fieldmax)");
        predictionList.add("Max PIPs (fieldmaxpip)");
        this.setSize(640, 450);
        this.setTitle("Realtime Encog Analyst Wizard");
        this.beginTab("Data");
        this.baseName = new TextField("ega file", "EGA File Name", true);
        this.addProperty(this.baseName);
        this.target = new ComboBoxField("target", "Target Platform", true, targets);
        this.addProperty(this.target);
        this.sourceData = new BuildingListField("source fields", "Source Fields");
        this.addProperty(this.sourceData);
        this.predictionField = new TextField("predict field", "Field (above) to predict", true);
        this.addProperty(this.predictionField);
        this.prediction = new ComboBoxField("prediction", "Prediction Type", true, predictionList);
        this.addProperty(this.prediction);
        this.forwardWindow = new IntegerField("forward window", "Forward Window", true, 0, 10000);
        this.addProperty(this.forwardWindow);
        this.backwardWindow = new IntegerField("backward window", "Backward Window", true, 0, 10000);
        this.addProperty(this.backwardWindow);
        this.sourceData.setOwner(this);
        this.render();
        this.sourceData.getModel().addElement("Name: time, Source: time");
        this.sourceData.getModel().addElement("Name: close, Source: Close[##]");
        this.predictionField.setValue("close");
        this.forwardWindow.setValue(60);
        this.backwardWindow.setValue(30);
        ((JComboBox)this.prediction.getField()).setSelectedIndex(0);
        ((JComboBox)this.target.getField()).setSelectedIndex(0);
        if (existingFile != null) {
            this.loadExistingFile(existingFile);
        }
    }

    private void loadExistingFile(File existingFile) {
        EncogAnalyst existingAnalyst = new EncogAnalyst();
        existingAnalyst.load(existingFile);
        this.sourceData.getModel().clear();
        DataField[] dataFieldArray = existingAnalyst.getScript().getFields();
        int n = dataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataField field = dataFieldArray[n2];
            if (!field.getName().equalsIgnoreCase("prediction")) {
                this.sourceData.getModel().addElement("Name: " + field.getName() + ", Source: " + field.getSource());
            }
            ++n2;
        }
    }

    public TextField getBaseName() {
        return this.baseName;
    }

    public List<SourceElement> getSourceData() {
        DefaultListModel ctrl = this.sourceData.getModel();
        ArrayList<SourceElement> result = new ArrayList<SourceElement>();
        int i = 0;
        while (i < ctrl.getSize()) {
            String current = this.sourceData.getModel().get(i).toString();
            int idx = current.indexOf(44);
            String currentName = current.substring(5, idx).trim();
            idx = current.indexOf("Source:");
            String currentSource = current.substring(idx + 7).trim();
            result.add(new SourceElement(currentName, currentSource));
            ++i;
        }
        return result;
    }

    private String askSource(int index) {
        IndicatorSourceDialog dialog = new IndicatorSourceDialog();
        if (index != -1) {
            String current = this.sourceData.getModel().get(index).toString();
            int idx = current.indexOf(44);
            String currentName = current.substring(5, idx).trim();
            idx = current.indexOf("Source:");
            String currentSource = current.substring(idx + 7).trim();
            dialog.getSourceName().setValue(currentName);
            dialog.getSource().setValue(currentSource);
        }
        if (dialog.process()) {
            return "Name: " + dialog.getSourceName().getValue() + ", Source: " + dialog.getSource().getValue();
        }
        return null;
    }

    @Override
    public void add(BuildingListField list, int index) {
        String str = this.askSource(-1);
        if (str != null) {
            list.getModel().addElement(str);
        }
    }

    @Override
    public void del(BuildingListField list, int index) {
        if (index != -1) {
            list.getModel().remove(index);
        }
    }

    @Override
    public void edit(BuildingListField list, int index) {
        String str;
        if (index != -1 && (str = this.askSource(index)) != null) {
            list.getModel().remove(index);
            list.getModel().add(index, str);
        }
    }

    public ComboBoxField getTarget() {
        return this.target;
    }

    public TextField getPredictionField() {
        return this.predictionField;
    }

    public PredictionType getPrediction() {
        switch (this.prediction.getSelectedIndex()) {
            case 0: {
                return PredictionType.fieldmax;
            }
            case 1: {
                return PredictionType.fieldmaxpip;
            }
        }
        return PredictionType.fieldmaxpip;
    }

    public IntegerField getForwardWindow() {
        return this.forwardWindow;
    }

    public IntegerField getBackwardWindow() {
        return this.backwardWindow;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setSourceData(BuildingListField sourceData) {
        this.sourceData = sourceData;
    }

    public TargetLanguage getTargetLanguage() {
        if (this.target.getSelectedIndex() == 0) {
            return TargetLanguage.NinjaScript;
        }
        return TargetLanguage.MQL4;
    }
}

