/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.wizard.analyst;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.AnalystGoal;
import org.encog.app.analyst.wizard.NormalizeRange;
import org.encog.app.analyst.wizard.WizardMethodType;
import org.encog.app.generate.TargetLanguage;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.DoubleField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.FileField;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.dialogs.common.TextField;
import org.encog.workbench.frames.document.EncogDocumentFrame;

public class AnalystWizardDialog
extends EncogPropertiesDialog {
    private final FileField rawFile;
    private final ComboBoxField method;
    private final ComboBoxField format;
    private final ComboBoxField range;
    private final ComboBoxField goal;
    private final ComboBoxField missing;
    private final TextField targetField;
    private final CheckField headers;
    private final IntegerField lagCount;
    private final IntegerField leadCount;
    private final CheckField includeTarget;
    private final CheckField normalize;
    private final CheckField segregate;
    private final CheckField randomize;
    private final CheckField balance;
    private final CheckField cluster;
    private final DoubleField maxError;
    private final ComboBoxField generationTarget;
    private final CheckField embedData;
    private final List<String> methods = new ArrayList<String>();

    public CheckField getCluster() {
        return this.cluster;
    }

    public AnalystWizardDialog() {
        super(EncogWorkBench.getInstance().getMainWindow());
        ArrayList<String> list = new ArrayList<String>();
        list.add("CSV");
        ArrayList<String> csvFormat = new ArrayList<String>();
        csvFormat.add("Decimal Point (USA/English) & Comma Separator");
        csvFormat.add("Decimal Point (USA/English) & Space Separator");
        csvFormat.add("Decimal Point (USA/English) & Semicolon Separator");
        csvFormat.add("Decimal Comma (Non-USA/English) & Space Separator");
        csvFormat.add("Decimal Comma (Non-USA/English) & Semicolon Separator");
        ArrayList<String> goalList = new ArrayList<String>();
        goalList.add("Classification");
        goalList.add("Regression");
        ArrayList<String> rangeList = new ArrayList<String>();
        rangeList.add("-1 to 1");
        rangeList.add("0 to 1");
        ArrayList<String> missingList = new ArrayList<String>();
        missingList.add("DiscardMissing");
        missingList.add("MeanAndModeMissing");
        missingList.add("NegateMissing");
        ArrayList<String> targetLanguages = new ArrayList<String>();
        targetLanguages.add("No Generation");
        targetLanguages.add("Java");
        targetLanguages.add("JavaScript");
        targetLanguages.add("CSharp");
        targetLanguages.add("MQL4");
        targetLanguages.add("NinjaScript");
        this.methods.add("Bayesian Network");
        this.methods.add("Encog Program (GP)");
        this.methods.add("Feedforward Network");
        this.methods.add("NEAT Network");
        this.methods.add("RBF Network");
        this.methods.add("PNN/GRNN Network");
        this.methods.add("Self Organizing Map (SOM)");
        this.methods.add("Support Vector Machine");
        this.setSize(640, 360);
        this.setTitle("Setup Encog Analyst Wizard");
        this.beginTab("General");
        this.rawFile = new FileField("source file", "Source CSV File(*.csv)", true, false, EncogDocumentFrame.CSV_FILTER);
        this.addProperty(this.rawFile);
        this.format = new ComboBoxField("format", "File Format", true, csvFormat);
        this.addProperty(this.format);
        this.method = new ComboBoxField("method", "Machine Learning", true, this.methods);
        this.addProperty(this.method);
        this.goal = new ComboBoxField("goal", "Goal", true, goalList);
        this.addProperty(this.goal);
        this.targetField = new TextField("target field", "Target Field(blank for auto)", false);
        this.addProperty(this.targetField);
        this.headers = new CheckField("headers", "CSV File Headers");
        this.addProperty(this.headers);
        this.range = new ComboBoxField("normalization range", "Normalization Range", true, rangeList);
        this.addProperty(this.range);
        this.missing = new ComboBoxField("missing values", "Missing Values", true, missingList);
        this.addProperty(this.missing);
        this.maxError = new DoubleField("max error", "Maximum Error Percent(0-100)", true, 0, 100);
        this.addProperty(this.maxError);
        this.beginTab("Time Series");
        this.lagCount = new IntegerField("lag count", "Lag Count", true, 0, 1000);
        this.addProperty(this.lagCount);
        this.leadCount = new IntegerField("lead count", "Lead Count", true, 0, 1000);
        this.addProperty(this.leadCount);
        this.includeTarget = new CheckField("include target", "Include Target in Input");
        this.addProperty(this.includeTarget);
        this.beginTab("Tasks");
        this.normalize = new CheckField("normalize", "Normalize");
        this.addProperty(this.normalize);
        this.randomize = new CheckField("randomize", "Randomize");
        this.addProperty(this.randomize);
        this.segregate = new CheckField("segregate", "Segregate");
        this.addProperty(this.segregate);
        this.balance = new CheckField("balance", "Balance");
        this.addProperty(this.balance);
        this.cluster = new CheckField("cluster", "Cluster");
        this.addProperty(this.cluster);
        this.beginTab("Code Generation");
        this.generationTarget = new ComboBoxField("language", "Generation Language", true, targetLanguages);
        this.addProperty(this.generationTarget);
        this.embedData = new CheckField("embed", "Embed Data");
        this.addProperty(this.embedData);
        this.render();
        this.lagCount.setValue(0);
        this.leadCount.setValue(0);
        this.randomize.setValue(true);
        this.segregate.setValue(true);
        this.normalize.setValue(true);
        this.balance.setValue(false);
        this.cluster.setValue(true);
        ((JComboBox)this.method.getField()).setSelectedIndex(2);
        this.getMaxError().setValue(EncogWorkBench.getInstance().getConfig().getDefaultError());
    }

    public FileField getRawFile() {
        return this.rawFile;
    }

    public CheckField getHeaders() {
        return this.headers;
    }

    public WizardMethodType getMethodType() {
        switch (this.method.getSelectedIndex()) {
            case 0: {
                return WizardMethodType.BayesianNetwork;
            }
            case 1: {
                return WizardMethodType.EPL;
            }
            case 2: {
                return WizardMethodType.FeedForward;
            }
            case 3: {
                return WizardMethodType.NEAT;
            }
            case 4: {
                return WizardMethodType.RBF;
            }
            case 5: {
                return WizardMethodType.PNN;
            }
            case 6: {
                return WizardMethodType.SOM;
            }
            case 7: {
                return WizardMethodType.SVM;
            }
        }
        return null;
    }

    public AnalystFileFormat getFormat() {
        int idx = this.format.getSelectedIndex();
        switch (idx) {
            case 0: {
                return AnalystFileFormat.DECPNT_COMMA;
            }
            case 1: {
                return AnalystFileFormat.DECPNT_SPACE;
            }
            case 2: {
                return AnalystFileFormat.DECPNT_SEMI;
            }
            case 3: {
                return AnalystFileFormat.DECCOMMA_SPACE;
            }
            case 4: {
                return AnalystFileFormat.DECCOMMA_SEMI;
            }
        }
        return null;
    }

    public AnalystGoal getGoal() {
        int idx = this.goal.getSelectedIndex();
        switch (idx) {
            case 0: {
                return AnalystGoal.Classification;
            }
            case 1: {
                return AnalystGoal.Regression;
            }
        }
        return null;
    }

    public NormalizeRange getRange() {
        int idx = this.range.getSelectedIndex();
        switch (idx) {
            case 0: {
                return NormalizeRange.NegOne2One;
            }
            case 1: {
                return NormalizeRange.Zero2One;
            }
        }
        return null;
    }

    public String getTargetField() {
        return this.targetField.getValue();
    }

    public IntegerField getLagCount() {
        return this.lagCount;
    }

    public IntegerField getLeadCount() {
        return this.leadCount;
    }

    public CheckField getIncludeTarget() {
        return this.includeTarget;
    }

    public CheckField getSegregate() {
        return this.segregate;
    }

    public CheckField getRandomize() {
        return this.randomize;
    }

    public CheckField getNormalize() {
        return this.normalize;
    }

    public CheckField getBalance() {
        return this.balance;
    }

    public ComboBoxField getMissing() {
        return this.missing;
    }

    public DoubleField getMaxError() {
        return this.maxError;
    }

    public ComboBoxField getGenerationTarget() {
        return this.generationTarget;
    }

    public CheckField getEmbedData() {
        return this.embedData;
    }

    public TargetLanguage getGenerationTargetLanguage() {
        switch (this.generationTarget.getSelectedIndex()) {
            case 0: {
                return TargetLanguage.NoGeneration;
            }
            case 1: {
                return TargetLanguage.Java;
            }
            case 2: {
                return TargetLanguage.JavaScript;
            }
            case 3: {
                return TargetLanguage.CSharp;
            }
            case 4: {
                return TargetLanguage.MQL4;
            }
            case 5: {
                return TargetLanguage.NinjaScript;
            }
        }
        return TargetLanguage.NoGeneration;
    }
}

