/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.population.epl;

import java.io.File;
import java.util.List;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.BuildingListField;
import org.encog.workbench.dialogs.common.BuildingListListener;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.frames.document.tree.ProjectTraining;

public class CreateEPLPopulationDialog
extends EncogPropertiesDialog
implements BuildingListListener {
    private final ComboBoxField comboTraining;
    private final BuildingListField inputVariables;
    private final IntegerField populationSize;
    private final IntegerField maxDepth;
    private List<ProjectTraining> trainingSets;

    public CreateEPLPopulationDialog() {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.findData();
        this.setSize(500, 400);
        this.setTitle("Create EPL Population");
        this.comboTraining = new ComboBoxField("training set", "Training Set (optinal)", false, this.trainingSets);
        this.addProperty(this.comboTraining);
        this.populationSize = new IntegerField("population size", "Population Size", true, 1, -1);
        this.addProperty(this.populationSize);
        this.maxDepth = new IntegerField("max depth", "Maximum Depth", true, 3, Integer.MAX_VALUE);
        this.addProperty(this.maxDepth);
        this.inputVariables = new BuildingListField("input variables", "Input Variables");
        this.addProperty(this.inputVariables);
        this.render();
        this.maxDepth.setValue(5);
    }

    public IntegerField getPopulationSize() {
        return this.populationSize;
    }

    public BuildingListField getInputVariables() {
        return this.inputVariables;
    }

    public IntegerField getMaxDepth() {
        return this.maxDepth;
    }

    public ComboBoxField getComboTraining() {
        return this.comboTraining;
    }

    private void findData() {
        this.trainingSets = EncogWorkBench.getInstance().getTrainingData();
    }

    public MLDataSet getTrainingSet() {
        if (this.comboTraining.getSelectedValue() == null) {
            return null;
        }
        File file = ((ProjectTraining)this.comboTraining.getSelectedValue()).getFile();
        BufferedMLDataSet result = new BufferedMLDataSet(file);
        return result;
    }

    @Override
    public void add(BuildingListField list, int index) {
        String str = EncogWorkBench.displayInput("Variable?");
        if (str != null) {
            list.getModel().addElement(str);
        }
    }

    @Override
    public void edit(BuildingListField list, int index) {
        String str;
        if (index != -1 && (str = EncogWorkBench.displayInput("Variable?")) != null) {
            list.getModel().remove(index);
            list.getModel().add(index, str);
        }
    }

    @Override
    public void del(BuildingListField list, int index) {
        if (index != -1) {
            list.getModel().remove(index);
        }
    }
}

