/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.encog.workbench.dialogs.common.PropertiesField;
import org.encog.workbench.dialogs.common.ValidationException;

public class TextAreaField
extends PropertiesField {
    private String value;
    private JTextArea textArea;

    public TextAreaField(String name, String label, boolean required) {
        super(name, label, required);
    }

    @Override
    public int createField(JPanel panel, int x, int y, int width) {
        this.textArea = new JTextArea(10, 10);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane scroll = new JScrollPane(this.textArea);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setLocation(x, y);
        scroll.setSize(scroll.getPreferredSize());
        scroll.setSize(width, scroll.getHeight());
        JLabel label = this.createLabel();
        label.setLocation(label.getX(), y);
        panel.add(label);
        panel.add(scroll);
        this.setField(scroll);
        return y + scroll.getHeight();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.textArea.setText(value);
    }

    @Override
    public void collect() throws ValidationException {
        this.value = this.textArea.getText();
        if (this.value.length() < 1 && this.isRequired()) {
            throw new ValidationException("The field " + this.getName() + " is required.");
        }
    }
}

