/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.encog.workbench.dialogs.common.EncogCommonDialog;
import org.encog.workbench.dialogs.common.PropertiesField;
import org.encog.workbench.dialogs.common.ValidationException;

public class EncogPropertiesDialog
extends EncogCommonDialog {
    private List<PropertiesField> nonTabbedproperties = new ArrayList<PropertiesField>();
    private List<PropertiesField> allProperties = new ArrayList<PropertiesField>();
    private List<String> tabs = new ArrayList<String>();
    private Map<String, List<PropertiesField>> tabMaps = new HashMap<String, List<PropertiesField>>();
    private List<PropertiesField> currentTab;
    private JTabbedPane tabPane;
    private boolean collectCurrentTabOnly = false;

    public EncogPropertiesDialog(Frame owner) {
        super(owner);
    }

    public EncogPropertiesDialog(JDialog owner) {
        super(owner);
    }

    public void render() {
        if (this.tabs.size() == 0) {
            this.renderNonTab();
        } else {
            this.renderTab();
        }
    }

    public void renderTab() {
        this.tabPane = new JTabbedPane();
        this.getContentPane().add(this.tabPane);
        for (String tabName : this.tabs) {
            JPanel tab = new JPanel();
            this.tabPane.addTab(tabName, tab);
            List<PropertiesField> tabProperties = this.tabMaps.get(tabName);
            this.renderProperties(tab, tabProperties);
        }
    }

    public void renderNonTab() {
        JPanel contents = this.getBodyPanel();
        this.renderProperties(contents, this.nonTabbedproperties);
    }

    public void renderProperties(JPanel contents, List<PropertiesField> properties) {
        int y = 0;
        int maxLabelWidth = 0;
        int dialogWidth = this.getWidth();
        boolean labelHeight = false;
        for (PropertiesField field : properties) {
            JLabel label = field.createLabel();
            if (label == null) continue;
            maxLabelWidth = Math.max(maxLabelWidth, label.getWidth());
        }
        contents.setLayout(new BorderLayout());
        JPanel view = new JPanel();
        view.setLayout(null);
        JScrollPane scroll = new JScrollPane(view);
        contents.add((Component)scroll, "Center");
        y = 0;
        for (PropertiesField field : properties) {
            y = field.createField(view, maxLabelWidth + 30, y, dialogWidth - maxLabelWidth - 50);
        }
        view.setPreferredSize(new Dimension(view.getWidth(), y));
    }

    public void beginTab(String tabName) {
        this.currentTab = new ArrayList<PropertiesField>();
        this.tabMaps.put(tabName, this.currentTab);
        this.tabs.add(tabName);
    }

    @Override
    public void collectFields() throws ValidationException {
        List<PropertiesField> list;
        if (this.collectCurrentTabOnly) {
            int index = this.tabPane.getSelectedIndex();
            String name = this.tabPane.getTitleAt(index);
            list = this.tabMaps.get(name);
        } else {
            list = this.allProperties;
        }
        for (PropertiesField field : list) {
            field.collect();
        }
    }

    @Override
    public void setFields() {
    }

    public void addProperty(PropertiesField field) {
        if (this.currentTab == null) {
            this.nonTabbedproperties.add(field);
            field.setOwner(this);
        } else {
            this.currentTab.add(field);
            field.setOwner(this);
        }
        this.allProperties.add(field);
    }

    public boolean isCollectCurrentTabOnly() {
        return this.collectCurrentTabOnly;
    }

    public void setCollectCurrentTabOnly(boolean collectCurrentTabOnly) {
        this.collectCurrentTabOnly = collectCurrentTabOnly;
    }

    public int getCurrentTab() {
        if (this.tabPane == null) {
            return -1;
        }
        return this.tabPane.getSelectedIndex();
    }
}

