/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.ValidationException;

public abstract class EncogCommonDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 8307697052772231235L;
    private JButton ctrlOK;
    private JButton ctrlCancel;
    private final JPanel bodyPanel = new JPanel();
    private final JPanel buttonPanel = new JPanel();
    private boolean shouldProcess;

    public EncogCommonDialog(Frame owner) {
        super(owner, true);
        this.init();
    }

    public EncogCommonDialog(JDialog owner) {
        super((Dialog)owner, true);
        this.init();
    }

    private void init() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.ctrlOK = new JButton("OK");
        this.buttonPanel.add(this.ctrlOK);
        this.ctrlCancel = new JButton("Cancel");
        this.buttonPanel.add(this.ctrlCancel);
        this.ctrlCancel.addActionListener(this);
        this.ctrlOK.addActionListener(this);
        content.add((Component)this.bodyPanel, "Center");
        content.add((Component)this.buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ctrlOK) {
            if (this.collect() && this.passesValidation()) {
                this.dispose();
                this.shouldProcess = true;
            }
        } else if (e.getSource() == this.ctrlCancel) {
            this.dispose();
            this.shouldProcess = false;
        }
    }

    public boolean passesValidation() {
        return true;
    }

    public boolean collect() {
        try {
            this.collectFields();
            return true;
        }
        catch (ValidationException e) {
            EncogWorkBench.displayError("Validation Error", e.getMessage());
            return false;
        }
    }

    public abstract void collectFields() throws ValidationException;

    public JPanel getBodyPanel() {
        return this.bodyPanel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public boolean process() {
        this.setFields();
        this.setVisible(true);
        return this.shouldProcess;
    }

    public abstract void setFields();

    public double validateFieldNumeric(String name, JTextField field) throws ValidationException {
        try {
            double d = Double.parseDouble(field.getText());
            return d;
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Must enter a valid number for: " + name);
        }
    }

    public double validateFieldNumeric(String name, JTextField field, double low, double high) throws ValidationException {
        double d = this.validateFieldNumeric(name, field);
        if (d < low) {
            throw new ValidationException("Must enter a value above " + low + " for: " + name);
        }
        if (high > low && d > high) {
            throw new ValidationException("Must enter a value below " + low + " for: " + name);
        }
        return d;
    }

    public String validateFieldString(String name, JComboBox field, boolean required) throws ValidationException {
        String result = (String)field.getSelectedItem();
        if (result == null && required) {
            throw new ValidationException("The " + name + " field is required.");
        }
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    public String validateFieldString(String name, JTextField field, boolean required) throws ValidationException {
        String result = field.getText().trim();
        if (result.length() < 1 && required) {
            throw new ValidationException("The " + name + " field is required.");
        }
        return result;
    }
}

