/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.activation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.activation.EquationPanel;
import org.encog.workbench.dialogs.activation.ParamsDialog;
import org.encog.workbench.dialogs.common.EncogCommonDialog;
import org.encog.workbench.dialogs.common.ValidationException;

public class ActivationDialog
extends EncogCommonDialog
implements ItemListener {
    public static final String[] ACTIVATION_FUNCTION = new String[]{"ActivationBiPolar", "ActivationBipolarSteepenedSigmoid", "ActivationClippedLinear", "ActivationCompetitive", "ActivationElliott", "ActivationElliottSymmetric", "ActivationGaussian", "ActivationGaussian", "ActivationLinear", "ActivationLOG", "ActivationRamp", "ActivationSigmoid", "ActivationSIN", "ActivationSIN", "ActivationSoftMax", "ActivationSteepenedSigmoid", "ActivationStep", "ActivationTANH"};
    private JComboBox select = new JComboBox<String>(ACTIVATION_FUNCTION);
    private EquationPanel equation;
    private JCheckBox derivative;
    private JButton params;
    private ActivationFunction activation;

    public ActivationDialog(JFrame owner) {
        super(owner);
        this.init();
    }

    public ActivationDialog(JDialog owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setSize(600, 300);
        JPanel contents = this.getBodyPanel();
        contents.setLayout(new BorderLayout());
        this.equation = new EquationPanel();
        contents.add((Component)this.equation, "Center");
        JPanel upper = new JPanel();
        upper.setLayout(new BorderLayout());
        contents.add((Component)upper, "North");
        this.select.addItemListener(this);
        this.derivative = new JCheckBox("View Derivative");
        upper.add((Component)this.select, "Center");
        this.params = new JButton("Params");
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 2));
        buttons.add(this.derivative);
        buttons.add(this.params);
        upper.add((Component)buttons, "East");
        this.derivative.addActionListener(this);
        this.params.addActionListener(this);
    }

    @Override
    public void collectFields() throws ValidationException {
    }

    @Override
    public void setFields() {
    }

    public void changeEquation() {
        boolean der = this.derivative.isSelected();
        ActivationFunction newActivation = null;
        String className = "org.encog.engine.network.activation." + this.select.getSelectedItem();
        try {
            newActivation = (ActivationFunction)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            EncogWorkBench.displayError("Error", e);
        }
        if (this.activation.getClass() != newActivation.getClass()) {
            this.activation = newActivation;
        }
        this.equation.setupEquation(newActivation, !der);
        this.params.setEnabled(this.activation.getParams().length > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.select) {
            this.changeEquation();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.derivative) {
            this.changeEquation();
        } else if (e.getSource() == this.params) {
            ParamsDialog dlg = new ParamsDialog(this, this.activation);
            dlg.load(this.activation);
            if (dlg.process()) {
                dlg.save(this.activation);
                this.equation.setupEquation(this.activation, !this.derivative.isSelected());
            }
        }
    }

    public ActivationFunction getActivation() {
        return this.activation;
    }

    public void setActivation(ActivationFunction activation) {
        this.activation = activation;
        int i = 0;
        while (i < ACTIVATION_FUNCTION.length) {
            if (ACTIVATION_FUNCTION[i].equals(activation.getClass().getSimpleName())) {
                this.select.setSelectedIndex(i);
            }
            ++i;
        }
        this.equation.setupEquation(this.activation, !this.derivative.isSelected());
    }
}

