/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench;

import java.util.Date;
import org.encog.plugin.EncogPluginLogging1;
import org.encog.plugin.system.SystemLoggingPlugin;
import org.encog.workbench.EncogWorkBench;

public class WorkbenchLogging
implements EncogPluginLogging1 {
    private int currentLevel = 4;

    @Override
    public int getPluginType() {
        return 1;
    }

    @Override
    public int getPluginServiceType() {
        return 1;
    }

    @Override
    public String getPluginName() {
        return "HRI-System-Logging";
    }

    @Override
    public String getPluginDescription() {
        return "Workbench logging";
    }

    @Override
    public int getLogLevel() {
        return this.currentLevel;
    }

    public void setLogLevel(int l) {
        this.currentLevel = l;
    }

    @Override
    public void log(int level, String message) {
        if (this.currentLevel <= level) {
            Date now = new Date();
            StringBuilder line = new StringBuilder();
            line.append(now.toString());
            line.append(" [");
            switch (level) {
                case 3: {
                    line.append("CRITICAL");
                    break;
                }
                case 2: {
                    line.append("ERROR");
                    break;
                }
                case 1: {
                    line.append("INFO");
                    break;
                }
                case 0: {
                    line.append("DEBUG");
                    break;
                }
                default: {
                    line.append("?");
                }
            }
            line.append("][");
            line.append(Thread.currentThread().getName());
            line.append("]: ");
            line.append(message);
            EncogWorkBench.getInstance().outputLine(line.toString());
        }
    }

    @Override
    public void log(int level, Throwable t) {
        String str = SystemLoggingPlugin.getStackTrace(t);
        System.err.println(str);
        this.log(level, str);
    }
}

