/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.simple;

import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.util.EngineArray;
import org.encog.util.ObjectPair;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class TrainingSetUtil {
    public static MLDataSet loadCSVTOMemory(CSVFormat format, String filename, boolean headers, int inputSize, int idealSize) {
        BasicMLDataSet result = new BasicMLDataSet();
        ReadCSV csv = new ReadCSV(filename, headers, format);
        while (csv.next()) {
            double d;
            BasicMLData input = null;
            BasicMLData ideal = null;
            int index = 0;
            input = new BasicMLData(inputSize);
            int i = 0;
            while (i < inputSize) {
                d = csv.getDouble(index++);
                input.setData(i, d);
                ++i;
            }
            if (idealSize > 0) {
                ideal = new BasicMLData(idealSize);
                i = 0;
                while (i < idealSize) {
                    d = csv.getDouble(index++);
                    ideal.setData(i, d);
                    ++i;
                }
            }
            BasicMLDataPair pair = new BasicMLDataPair(input, ideal);
            result.add(pair);
        }
        return result;
    }

    public static ObjectPair<double[][], double[][]> trainingToArray(MLDataSet training) {
        int length = (int)training.getRecordCount();
        double[][] a = new double[length][training.getInputSize()];
        double[][] b = new double[length][training.getIdealSize()];
        int index = 0;
        for (MLDataPair pair : training) {
            EngineArray.arrayCopy(pair.getInputArray(), a[index]);
            EngineArray.arrayCopy(pair.getIdealArray(), b[index]);
            ++index;
        }
        return new ObjectPair<double[][], double[][]>(a, b);
    }
}

