/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.kmeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.encog.util.kmeans.Centroid;
import org.encog.util.kmeans.CentroidFactory;
import org.encog.util.kmeans.Cluster;

public class KMeansUtil<K extends CentroidFactory<? super K>> {
    private final ArrayList<Cluster<K>> clusters;
    private final int k;

    public KMeansUtil(int theK, List<? extends K> theElements) {
        this.k = theK;
        this.clusters = new ArrayList(theK);
        this.initRandomClusters(theElements);
    }

    private void initRandomClusters(List<? extends K> elements) {
        int i = 0;
        while (i < this.k) {
            this.clusters.add(new Cluster());
            ++i;
        }
        int amountLeft = elements.size();
        int place = -1;
        for (CentroidFactory e : elements) {
            if (amountLeft-- == this.k) {
                place = 0;
            }
            if (place >= 0) {
                while (place < this.clusters.size()) {
                    Cluster<K> c = this.clusters.get(place);
                    if (c.getContents().isEmpty()) {
                        c.add(e);
                        break;
                    }
                    ++place;
                }
                if (place != this.clusters.size()) continue;
                place = -1;
            }
            this.clusters.get((int)Math.floor(Math.random() * (double)this.k)).add(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void process() {
        void var2_5;
        void var2_3;
        ArrayList newclusters = new ArrayList();
        boolean bl = false;
        while (var2_3 < this.k) {
            newclusters.add(new Cluster());
            ++var2_3;
        }
        boolean bl2 = false;
        while (var2_5 < this.k) {
            Cluster<K> thisCluster = this.clusters.get((int)var2_5);
            List<K> thisElements = thisCluster.getContents();
            int j = 0;
            while (j < thisElements.size()) {
                CentroidFactory thisElement = (CentroidFactory)thisElements.get(j);
                int nearestCluster = this.nearestClusterIndex(thisElement);
                ((Cluster)newclusters.get(nearestCluster)).add(thisElement);
                ++j;
            }
            ++var2_5;
        }
        this.clusters.clear();
        for (Cluster cluster : newclusters) {
            this.clusters.add(cluster);
        }
    }

    private Cluster<K> nearestCluster(K element) {
        return this.clusters.get(this.nearestClusterIndex(element));
    }

    private int nearestClusterIndex(K element) {
        double distance = Double.MAX_VALUE;
        int result = -1;
        int i = 0;
        while (i < this.clusters.size()) {
            double thisDistance;
            Centroid<K> c = this.clusters.get(i).centroid();
            if (c != null && distance > (thisDistance = c.distance(element))) {
                distance = thisDistance;
                result = i;
            }
            ++i;
        }
        return result;
    }

    public Collection<K> get(int index) {
        return this.clusters.get(index).getContents();
    }

    public int size() {
        return this.clusters.size();
    }

    public Cluster<K> getCluster(int i) {
        return this.clusters.get(i);
    }
}

