/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.datastruct;

import org.encog.EncogError;

public class StackInt {
    private int[] stack;
    private int head = 0;

    public StackInt(int size) {
        this.stack = new int[size];
    }

    public boolean isEmpty() {
        return this.head == 0;
    }

    public void push(int i) {
        if (this.head == this.stack.length) {
            throw new EncogError("Stack overflow");
        }
        this.stack[this.head++] = i;
    }

    public int pop() {
        if (this.head == 0) {
            throw new EncogError("Stack is empty");
        }
        return this.stack[--this.head];
    }

    public int add() {
        int a = this.pop();
        int b = this.pop();
        int result = b + a;
        this.push(result);
        return result;
    }

    public int sub() {
        int a = this.pop();
        int b = this.pop();
        int result = b - a;
        this.push(result);
        return result;
    }

    public int mul() {
        int a = this.pop();
        int b = this.pop();
        int result = b * a;
        this.push(result);
        return result;
    }

    public int div() {
        int a = this.pop();
        int b = this.pop();
        int result = b / a;
        this.push(result);
        return result;
    }

    public int size() {
        return this.head;
    }

    public int max(int size) {
        if (this.size() < size) {
            throw new EncogError("Not enough data on stack.");
        }
        int result = Integer.MIN_VALUE;
        int i = 0;
        while (i < size) {
            result = Math.max(result, this.pop());
            ++i;
        }
        this.push(result);
        return result;
    }

    public int min(int size) {
        if (this.size() < size) {
            throw new EncogError("Not enough data on stack.");
        }
        int result = Integer.MAX_VALUE;
        int i = 0;
        while (i < size) {
            result = Math.min(result, this.pop());
            ++i;
        }
        this.push(result);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[StackInt: ");
        int i = this.head - 1;
        while (i >= 0) {
            result.append(this.stack[i]);
            result.append(" ");
            --i;
        }
        result.append("]");
        return result.toString();
    }
}

