/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.concurrency;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.encog.EncogError;
import org.encog.util.concurrency.EngineTask;
import org.encog.util.concurrency.MultiThreadable;
import org.encog.util.concurrency.PoolItem;
import org.encog.util.concurrency.TaskGroup;

public class EngineConcurrency
implements MultiThreadable {
    private static EngineConcurrency instance = new EngineConcurrency();
    private Throwable threadError;
    private int threadCount;
    private int currentTaskGroup;
    private ExecutorService executor;

    public static EngineConcurrency getInstance() {
        return instance;
    }

    public EngineConcurrency() {
        Runtime runtime = Runtime.getRuntime();
        int threads = runtime.availableProcessors();
        this.executor = Executors.newFixedThreadPool(threads);
    }

    @Override
    public void setThreadCount(int t) {
        if (this.executor != null) {
            Runtime runtime;
            this.executor.shutdown();
            int threads = t;
            if (threads == 0 && (threads = (runtime = Runtime.getRuntime()).availableProcessors()) > 1) {
                ++threads;
            }
            this.executor = Executors.newFixedThreadPool(threads);
            this.threadCount = threads;
        }
    }

    public void checkError() {
        if (this.threadError != null) {
            throw new EncogError(this.threadError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskGroup createTaskGroup() {
        TaskGroup result = null;
        EngineConcurrency engineConcurrency = this;
        synchronized (engineConcurrency) {
            ++this.currentTaskGroup;
            result = new TaskGroup(this.currentTaskGroup);
        }
        return result;
    }

    public void processTask(EngineTask task) {
        this.processTask(task, null);
    }

    public void processTask(EngineTask task, TaskGroup group) {
        if (this.executor == null) {
            task.run();
        } else {
            if (this.threadError != null) {
                Throwable t = this.threadError;
                this.threadError = null;
                throw new EncogError(t);
            }
            PoolItem item = new PoolItem(task, group);
            if (group != null) {
                group.taskStarting();
            }
            this.executor.execute(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerError(Throwable t) {
        EngineConcurrency engineConcurrency = this;
        synchronized (engineConcurrency) {
            this.threadError = t;
        }
    }

    public void shutdown(long timeout) {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(timeout, TimeUnit.SECONDS);
                this.executor = null;
            }
            catch (InterruptedException e) {
                throw new EncogError(e);
            }
        }
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }
}

