/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import java.io.File;
import org.encog.StatusReportable;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.util.Format;
import org.encog.util.benchmark.Evaluate;
import org.encog.util.benchmark.RandomTrainingFactory;

public class EncogBenchmark {
    private static final int STEPS = 4;
    private static final int STEP1 = 1;
    private static final int STEP3 = 3;
    private static final int STEP4 = 4;
    private final StatusReportable report;
    private int cpuScore;
    private int clScore;
    private int memoryScore;
    private int binaryScore;

    public EncogBenchmark(StatusReportable report) {
        this.report = report;
    }

    public String process() {
        this.report.report(4, 0, "Beginning benchmark");
        this.evalCPU();
        this.evalMemory();
        this.evalBinary();
        StringBuilder result = new StringBuilder();
        result.append("Encog Benchmark: CPU:");
        result.append(Format.formatInteger(this.cpuScore));
        result.append(", Memory:");
        result.append(Format.formatInteger(this.memoryScore));
        result.append(", Disk:");
        result.append(Format.formatInteger(this.binaryScore));
        this.report.report(4, 4, result.toString());
        return result.toString();
    }

    private void evalCPU() {
        int small = Evaluate.evaluateTrain(2, 4, 0, 1);
        this.report.report(4, 1, "Evaluate CPU, tiny= " + Format.formatInteger(small / 100));
        int medium = Evaluate.evaluateTrain(10, 20, 0, 1);
        this.report.report(4, 1, "Evaluate CPU, small= " + Format.formatInteger(medium / 30));
        int large = Evaluate.evaluateTrain(100, 200, 40, 5);
        this.report.report(4, 1, "Evaluate CPU, large= " + Format.formatInteger(large));
        int huge = Evaluate.evaluateTrain(200, 300, 200, 50);
        this.report.report(4, 1, "Evaluate CPU, huge= " + Format.formatInteger(huge));
        int result = small / 100 + medium / 30 + large + huge;
        this.report.report(4, 1, "CPU result: " + result);
        this.cpuScore = result;
    }

    private void evalMemory() {
        BasicMLDataSet training = RandomTrainingFactory.generate(1000L, 10000, 10, 10, -1.0, 1.0);
        long start = System.currentTimeMillis();
        long stop = start + 10000L;
        int record = 0;
        MLDataPair pair = BasicMLDataPair.createPair(10, 10);
        int iterations = 0;
        while (System.currentTimeMillis() < stop) {
            ++iterations;
            training.getRecord(record++, pair);
            if ((long)record < training.getRecordCount()) continue;
            record = 0;
        }
        this.report.report(4, 3, "Memory dataset, result: " + Format.formatInteger(iterations /= 100000));
        this.memoryScore = iterations;
    }

    private void evalBinary() {
        File file = new File("temp.egb");
        BasicMLDataSet training = RandomTrainingFactory.generate(1000L, 10000, 10, 10, -1.0, 1.0);
        file.delete();
        BufferedMLDataSet training2 = new BufferedMLDataSet(file);
        training2.load(training);
        long start = System.currentTimeMillis();
        long stop = start + 10000L;
        int record = 0;
        MLDataPair pair = BasicMLDataPair.createPair(10, 10);
        int iterations = 0;
        while (System.currentTimeMillis() < stop) {
            ++iterations;
            training2.getRecord(record++, pair);
            if ((long)record < training2.getRecordCount()) continue;
            record = 0;
        }
        training.close();
        this.report.report(4, 4, "Disk(binary) dataset, result: " + Format.formatInteger(iterations /= 100000));
        file.delete();
        this.binaryScore = iterations;
    }

    public int getCpuScore() {
        return this.cpuScore;
    }

    public int getClScore() {
        return this.clScore;
    }

    public int getMemoryScore() {
        return this.memoryScore;
    }

    public int getBinaryScore() {
        return this.binaryScore;
    }
}

