/*
 * Decompiled with CFR 0.152.
 */
package org.encog.plugin.system;

import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationBiPolar;
import org.encog.engine.network.activation.ActivationCompetitive;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationGaussian;
import org.encog.engine.network.activation.ActivationLOG;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.activation.ActivationRamp;
import org.encog.engine.network.activation.ActivationReLU;
import org.encog.engine.network.activation.ActivationSIN;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationSoftMax;
import org.encog.engine.network.activation.ActivationSteepenedSigmoid;
import org.encog.engine.network.activation.ActivationStep;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.plugin.EncogPluginService1;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class SystemActivationPlugin
implements EncogPluginService1 {
    @Override
    public final String getPluginDescription() {
        return "This plugin provides the built in machine learning methods for Encog.";
    }

    @Override
    public final String getPluginName() {
        return "HRI-System-Methods";
    }

    @Override
    public final int getPluginType() {
        return 1;
    }

    private ActivationFunction allocateAF(String name) {
        if (name.equalsIgnoreCase("bipolar")) {
            return new ActivationBiPolar();
        }
        if (name.equalsIgnoreCase("comp")) {
            return new ActivationCompetitive();
        }
        if (name.equalsIgnoreCase("gauss")) {
            return new ActivationGaussian();
        }
        if (name.equalsIgnoreCase("linear")) {
            return new ActivationLinear();
        }
        if (name.equalsIgnoreCase("log")) {
            return new ActivationLOG();
        }
        if (name.equalsIgnoreCase("ramp")) {
            return new ActivationRamp();
        }
        if (name.equalsIgnoreCase("sigmoid")) {
            return new ActivationSigmoid();
        }
        if (name.equalsIgnoreCase("sin")) {
            return new ActivationSIN();
        }
        if (name.equalsIgnoreCase("softmax")) {
            return new ActivationSoftMax();
        }
        if (name.equalsIgnoreCase("step")) {
            return new ActivationStep();
        }
        if (name.equalsIgnoreCase("tanh")) {
            return new ActivationTANH();
        }
        if (name.equalsIgnoreCase("ssigmoid")) {
            return new ActivationSteepenedSigmoid();
        }
        if (name.equalsIgnoreCase("relu")) {
            return new ActivationReLU();
        }
        return null;
    }

    @Override
    public ActivationFunction createActivationFunction(String fn) {
        double[] params;
        String name;
        int index = fn.indexOf(91);
        if (index != -1) {
            name = fn.substring(0, index).toLowerCase();
            int index2 = fn.indexOf(93);
            if (index2 == -1) {
                throw new EncogError("Unbounded [ while parsing activation function.");
            }
            String a = fn.substring(index + 1, index2);
            params = NumberList.fromList(CSVFormat.EG_FORMAT, a);
        } else {
            name = fn.toLowerCase();
            params = new double[]{};
        }
        ActivationFunction af = this.allocateAF(name);
        if (af == null) {
            return null;
        }
        if (params.length > 0) {
            if (af.getParamNames().length != params.length) {
                throw new EncogError(String.valueOf(name) + " expected " + af.getParamNames().length + ", but " + params.length + " were provided.");
            }
            int i = 0;
            while (i < af.getParamNames().length) {
                af.setParam(i, params[i]);
                ++i;
            }
        }
        return af;
    }

    @Override
    public MLMethod createMethod(String methodType, String architecture, int input, int output) {
        return null;
    }

    @Override
    public MLTrain createTraining(MLMethod method, MLDataSet training, String type, String args) {
        return null;
    }

    @Override
    public int getPluginServiceType() {
        return 0;
    }
}

