/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.expression.latex;

import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.ConstantPool;
import org.encog.ml.prg.extension.NodeType;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.parse.expression.ExpressionNodeType;
import org.encog.util.Format;

public class RenderLatexExpression {
    private EncogProgram program;
    private int roundDigits = 2;

    public String render(EncogProgram theProgram) {
        this.program = theProgram;
        return this.renderNode(this.program.getRootNode());
    }

    private String handleConst(ProgramNode node) {
        ExpressionValue v = node.evaluate();
        if (v.getExpressionType() == ValueType.floatingType) {
            return Format.formatDouble(v.toFloatValue(), this.roundDigits);
        }
        return v.toStringValue();
    }

    private String handleVar(ProgramNode node) {
        int varIndex = (int)node.getData()[0].toIntValue();
        return this.program.getVariables().getVariableName(varIndex);
    }

    private String handleFunction(ProgramNode node) {
        ProgramExtensionTemplate temp = node.getTemplate();
        StringBuilder result = new StringBuilder();
        if (temp == StandardExtensions.EXTENSION_SQRT) {
            result.append("\\sqrt{");
            result.append(this.renderNode(node.getChildNode(0)));
            result.append("}");
        } else {
            result.append(temp.getName());
            result.append('(');
            int i = 0;
            while (i < temp.getChildNodeCount()) {
                if (i > 0) {
                    result.append(',');
                }
                result.append(this.renderNode(node.getChildNode(i)));
                ++i;
            }
            result.append(')');
        }
        return result.toString();
    }

    private String handleOperator(ProgramNode node) {
        ProgramExtensionTemplate temp = node.getTemplate();
        StringBuilder result = new StringBuilder();
        if (temp.getChildNodeCount() == 2) {
            String a = this.renderNode(node.getChildNode(0));
            String b = this.renderNode(node.getChildNode(1));
            if (temp == StandardExtensions.EXTENSION_DIV) {
                result.append("\\frac{");
                result.append(b);
                result.append("}{");
                result.append(a);
                result.append("}");
            } else if (temp == StandardExtensions.EXTENSION_MUL) {
                result.append("(");
                result.append(b);
                result.append("\\cdot ");
                result.append(a);
                result.append(")");
            } else {
                result.append("({");
                result.append(b);
                result.append("}");
                result.append(temp.getName());
                result.append("{");
                result.append(a);
                result.append("})");
            }
        } else if (temp.getChildNodeCount() == 1) {
            String a = this.renderNode(node.getChildNode(0));
            result.append("(");
            result.append(temp.getName());
            result.append(a);
            result.append(")");
        } else {
            throw new EACompileError("An operator must have an arity of 1 or 2, probably should be made a function.");
        }
        return result.toString();
    }

    public ExpressionNodeType determineNodeType(ProgramNode node) {
        if (node.getTemplate() instanceof ConstantPool) {
            return ExpressionNodeType.ConstVal;
        }
        if (node.getTemplate() == StandardExtensions.EXTENSION_CONST_SUPPORT) {
            return ExpressionNodeType.ConstVal;
        }
        if (node.getTemplate() == StandardExtensions.EXTENSION_VAR_SUPPORT) {
            return ExpressionNodeType.Variable;
        }
        if (node.getTemplate().getNodeType() == NodeType.OperatorLeft || node.getTemplate().getNodeType() == NodeType.OperatorRight) {
            return ExpressionNodeType.Operator;
        }
        return ExpressionNodeType.Function;
    }

    private String renderNode(ProgramNode node) {
        switch (this.determineNodeType(node)) {
            case ConstVal: {
                return this.handleConst(node);
            }
            case Operator: {
                return this.handleOperator(node);
            }
            case Variable: {
                return this.handleVar(node);
            }
            case Function: {
                return this.handleFunction(node);
            }
        }
        throw new EACompileError("Uknown node type: " + node.toString());
    }

    public int getRoundDigits() {
        return this.roundDigits;
    }

    public void setRoundDigits(int roundDigits) {
        this.roundDigits = roundDigits;
    }
}

