/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse;

import java.io.IOException;
import java.io.InputStream;
import org.encog.bot.BotError;

public class PeekableInputStream
extends InputStream {
    public static final int INITIAL_DEPTH = 10;
    private final InputStream stream;
    private byte[] peekBytes;
    private int peekLength;

    public PeekableInputStream(InputStream is) {
        this.stream = is;
        this.peekBytes = new byte[10];
        this.peekLength = 0;
    }

    public int peek() {
        return this.peek(0);
    }

    public int peek(int depth) {
        block5: {
            block6: {
                try {
                    if (this.peekBytes.length <= depth) {
                        byte[] temp = new byte[depth + 10];
                        int i = 0;
                        while (i < this.peekBytes.length) {
                            temp[i] = this.peekBytes[i];
                            ++i;
                        }
                        this.peekBytes = temp;
                    }
                    if (depth < this.peekLength) break block5;
                    int offset = this.peekLength;
                    int length = depth - this.peekLength + 1;
                    int lengthRead = this.stream.read(this.peekBytes, offset, length);
                    if (lengthRead != -1) break block6;
                    return -1;
                }
                catch (IOException e) {
                    throw new BotError(e);
                }
            }
            this.peekLength = depth + 1;
        }
        return this.peekBytes[depth];
    }

    public boolean peek(String str) {
        int i = 0;
        while (i < str.length()) {
            if (this.peek(i) != str.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int read() {
        try {
            if (this.peekLength == 0) {
                return this.stream.read();
            }
            byte result = this.peekBytes[0];
            --this.peekLength;
            int i = 0;
            while (i < this.peekLength) {
                this.peekBytes[i] = this.peekBytes[i + 1];
                ++i;
            }
            return result;
        }
        catch (IOException e) {
            throw new BotError(e);
        }
    }

    @Override
    public long skip(long count) {
        long count2 = count;
        while (count2 > 0L) {
            this.read();
            --count2;
        }
        return count;
    }
}

