/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.thermal;

import org.encog.mathutil.matrices.BiPolarUtil;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.ml.data.MLData;
import org.encog.ml.data.specific.BiPolarNeuralData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.thermal.ThermalNetwork;
import org.encog.util.EngineArray;

public class HopfieldNetwork
extends ThermalNetwork {
    private static final long serialVersionUID = 1L;

    public HopfieldNetwork() {
    }

    public HopfieldNetwork(int neuronCount) {
        super(neuronCount);
    }

    public void addPattern(MLData pattern) {
        if (pattern.size() != this.getNeuronCount()) {
            throw new NeuralNetworkError("Network with " + this.getNeuronCount() + " neurons, cannot learn a pattern of size " + pattern.size());
        }
        Matrix m2 = Matrix.createRowMatrix(pattern.getData());
        Matrix m1 = MatrixMath.transpose(m2);
        Matrix m3 = MatrixMath.multiply(m1, m2);
        Matrix identity = MatrixMath.identity(m3.getRows());
        Matrix m4 = MatrixMath.subtract(m3, identity);
        this.convertHopfieldMatrix(m4);
    }

    @Override
    public MLData compute(MLData input) {
        BiPolarNeuralData result = new BiPolarNeuralData(input.size());
        EngineArray.arrayCopy(input.getData(), this.getCurrentState().getData());
        this.run();
        int i = 0;
        while (i < this.getCurrentState().size()) {
            result.setData(i, BiPolarUtil.double2bipolar(this.getCurrentState().getData(i)));
            ++i;
        }
        EngineArray.arrayCopy(this.getCurrentState().getData(), result.getData());
        return result;
    }

    private void convertHopfieldMatrix(Matrix delta) {
        int row = 0;
        while (row < delta.getRows()) {
            int col = 0;
            while (col < delta.getRows()) {
                this.addWeight(row, col, delta.get(row, col));
                ++col;
            }
            ++row;
        }
    }

    @Override
    public int getInputCount() {
        return super.getNeuronCount();
    }

    @Override
    public int getOutputCount() {
        return super.getNeuronCount();
    }

    public void run() {
        int toNeuron = 0;
        while (toNeuron < this.getNeuronCount()) {
            double sum = 0.0;
            int fromNeuron = 0;
            while (fromNeuron < this.getNeuronCount()) {
                sum += this.getCurrentState().getData(fromNeuron) * this.getWeight(fromNeuron, toNeuron);
                ++fromNeuron;
            }
            this.getCurrentState().setData(toNeuron, sum);
            ++toNeuron;
        }
    }

    public int runUntilStable(int max) {
        boolean done = false;
        String lastStateStr = this.getCurrentState().toString();
        String currentStateStr = this.getCurrentState().toString();
        int cycle = 0;
        do {
            this.run();
            ++cycle;
            lastStateStr = this.getCurrentState().toString();
            if (!currentStateStr.equals(lastStateStr)) {
                if (cycle > max) {
                    done = true;
                }
            } else {
                done = true;
            }
            currentStateStr = lastStateStr;
        } while (!done);
        return cycle;
    }

    @Override
    public void updateProperties() {
    }
}

