/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som.training.basic.neighborhood;

import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MexicanHatFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.mathutil.rbf.RadialBasisFunction;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodFunction;
import org.encog.util.EngineArray;

public class NeighborhoodRBF
implements NeighborhoodFunction {
    private RadialBasisFunction rbf;
    private final int[] size;
    private int[] displacement;

    public NeighborhoodRBF(RBFEnum type, int x, int y) {
        int[] size = new int[]{x, y};
        double[] centerArray = new double[]{0.0, 0.0};
        double[] widthArray = new double[]{1.0, 1.0};
        switch (type) {
            case Gaussian: {
                this.rbf = new GaussianFunction(2);
                break;
            }
            case InverseMultiquadric: {
                this.rbf = new InverseMultiquadricFunction(2);
                break;
            }
            case Multiquadric: {
                this.rbf = new MultiquadricFunction(2);
                break;
            }
            case MexicanHat: {
                this.rbf = new MexicanHatFunction(2);
            }
        }
        this.rbf.setWidth(1.0);
        EngineArray.arrayCopy(centerArray, this.rbf.getCenters());
        this.size = size;
        this.calculateDisplacement();
    }

    public NeighborhoodRBF(int[] size, RBFEnum type) {
        switch (type) {
            case Gaussian: {
                this.rbf = new GaussianFunction(size.length);
                break;
            }
            case InverseMultiquadric: {
                this.rbf = new InverseMultiquadricFunction(size.length);
                break;
            }
            case Multiquadric: {
                this.rbf = new MultiquadricFunction(size.length);
                break;
            }
            case MexicanHat: {
                this.rbf = new MexicanHatFunction(size.length);
            }
        }
        this.size = size;
        this.calculateDisplacement();
    }

    private void calculateDisplacement() {
        this.displacement = new int[this.size.length];
        int i = 0;
        while (i < this.size.length) {
            int value = i == 0 ? 0 : (i == 1 ? this.size[0] : this.displacement[i - 1] * this.size[i - 1]);
            this.displacement[i] = value;
            ++i;
        }
    }

    @Override
    public double function(int currentNeuron, int bestNeuron) {
        double[] vector = new double[this.displacement.length];
        int[] vectorCurrent = this.translateCoordinates(currentNeuron);
        int[] vectorBest = this.translateCoordinates(bestNeuron);
        int i = 0;
        while (i < vectorCurrent.length) {
            vector[i] = vectorCurrent[i] - vectorBest[i];
            ++i;
        }
        return this.rbf.calculate(vector);
    }

    @Override
    public double getRadius() {
        return this.rbf.getWidth();
    }

    public RadialBasisFunction getRBF() {
        return this.rbf;
    }

    @Override
    public void setRadius(double radius) {
        this.rbf.setWidth(radius);
    }

    private int[] translateCoordinates(int index) {
        int[] result = new int[this.displacement.length];
        int countingIndex = index;
        int i = this.displacement.length - 1;
        while (i >= 0) {
            int value = this.displacement[i] > 0 ? countingIndex / this.displacement[i] : countingIndex;
            countingIndex -= this.displacement[i] * value;
            result[i] = value;
            --i;
        }
        return result;
    }
}

