/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.rbf.training;

import org.encog.mathutil.rbf.RadialBasisFunction;

public class SVD {
    public static double svdfit(double[][] x, double[][] y, double[][] a, RadialBasisFunction[] funcs) {
        int j;
        double TOL = 1.0E-13;
        double[][] u = new double[x.length][funcs.length];
        double[][] v = new double[funcs.length][funcs.length];
        double[] w = new double[funcs.length];
        int i = 0;
        while (i < x.length) {
            j = 0;
            while (j < funcs.length) {
                u[i][j] = funcs[j].calculate(x[i]);
                ++j;
            }
            ++i;
        }
        SVD.svdcmp(u, w, v);
        double wmax = 0.0;
        j = 0;
        while (j < funcs.length) {
            if (w[j] > wmax) {
                wmax = w[j];
            }
            ++j;
        }
        double thresh = TOL * wmax;
        j = 0;
        while (j < funcs.length) {
            if (w[j] < thresh) {
                w[j] = 0.0;
            }
            ++j;
        }
        SVD.svdbksb(u, w, v, y, a);
        double chisq = 0.0;
        int k = 0;
        while (k < y[0].length) {
            i = 0;
            while (i < y.length) {
                double sum = 0.0;
                j = 0;
                while (j < funcs.length) {
                    sum += a[j][k] * funcs[j].calculate(x[i]);
                    ++j;
                }
                double tmp = y[i][k] - sum;
                chisq += tmp * tmp;
                ++i;
            }
            ++k;
        }
        return Math.sqrt(chisq / (double)(y.length * y[0].length));
    }

    public static void svdbksb(double[][] u, double[] w, double[][] v, double[][] b, double[][] x) {
        int m = u.length;
        int n = u[0].length;
        double[] temp = new double[n];
        int k = 0;
        while (k < b[0].length) {
            double s;
            int j = 0;
            while (j < n) {
                s = 0.0;
                if (w[j] != 0.0) {
                    int i = 0;
                    while (i < m) {
                        s += u[i][j] * b[i][k];
                        ++i;
                    }
                    s /= w[j];
                }
                temp[j] = s;
                ++j;
            }
            j = 0;
            while (j < n) {
                s = 0.0;
                int jj = 0;
                while (jj < n) {
                    s += v[j][jj] * temp[jj];
                    ++jj;
                }
                x[j][k] = s;
                ++j;
            }
            ++k;
        }
    }

    public static void svdcmp(double[][] a, double[] w, double[][] v) {
        int j;
        double h;
        double f;
        int k;
        double s;
        int l = 0;
        int nm = 0;
        int m = a.length;
        int n = a[0].length;
        double[] rv1 = new double[n];
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        int i = 0;
        while (i < n) {
            l = i + 2;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m) {
                k = i;
                while (k < m) {
                    scale += Math.abs(a[k][i]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = i;
                    while (k < m) {
                        double[] dArray = a[k];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += a[k][i] * a[k][i];
                        ++k;
                    }
                    f = a[i][i];
                    g = -SVD.SIGN(Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][i] = f - g;
                    j = l - 1;
                    while (j < n) {
                        s = 0.0;
                        k = i;
                        while (k < m) {
                            s += a[k][i] * a[k][j];
                            ++k;
                        }
                        f = s / h;
                        k = i;
                        while (k < m) {
                            double[] dArray = a[k];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + f * a[k][i];
                            ++k;
                        }
                        ++j;
                    }
                    k = i;
                    while (k < m) {
                        double[] dArray = a[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                        ++k;
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i + 1 <= m && i + 1 != n) {
                k = l - 1;
                while (k < n) {
                    scale += Math.abs(a[i][k]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = l - 1;
                    while (k < n) {
                        double[] dArray = a[i];
                        int n5 = k;
                        dArray[n5] = dArray[n5] / scale;
                        s += a[i][k] * a[i][k];
                        ++k;
                    }
                    f = a[i][l - 1];
                    g = -SVD.SIGN(Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][l - 1] = f - g;
                    k = l - 1;
                    while (k < n) {
                        rv1[k] = a[i][k] / h;
                        ++k;
                    }
                    j = l - 1;
                    while (j < m) {
                        s = 0.0;
                        k = l - 1;
                        while (k < n) {
                            s += a[j][k] * a[i][k];
                            ++k;
                        }
                        k = l - 1;
                        while (k < n) {
                            double[] dArray = a[j];
                            int n6 = k;
                            dArray[n6] = dArray[n6] + s * rv1[k];
                            ++k;
                        }
                        ++j;
                    }
                    k = l - 1;
                    while (k < n) {
                        double[] dArray = a[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = SVD.MAX(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    j = l;
                    while (j < n) {
                        v[j][i] = a[i][j] / a[i][l] / g;
                        ++j;
                    }
                    j = l;
                    while (j < n) {
                        s = 0.0;
                        k = l;
                        while (k < n) {
                            s += a[i][k] * v[k][j];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            double[] dArray = v[k];
                            int n8 = j;
                            dArray[n8] = dArray[n8] + s * v[k][i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < n) {
                    v[j][i] = 0.0;
                    v[i][j] = 0.0;
                    ++j;
                }
            }
            v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = SVD.MIN(m, n) - 1;
        while (i >= 0) {
            l = i + 1;
            g = w[i];
            j = l;
            while (j < n) {
                a[i][j] = 0.0;
                ++j;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                j = l;
                while (j < n) {
                    s = 0.0;
                    k = l;
                    while (k < m) {
                        s += a[k][i] * a[k][j];
                        ++k;
                    }
                    f = s / a[i][i] * g;
                    k = i;
                    while (k < m) {
                        double[] dArray = a[k];
                        int n9 = j;
                        dArray[n9] = dArray[n9] + f * a[k][i];
                        ++k;
                    }
                    ++j;
                }
                j = i;
                while (j < m) {
                    double[] dArray = a[j];
                    int n10 = i;
                    dArray[n10] = dArray[n10] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < m) {
                    a[j][i] = 0.0;
                    ++j;
                }
            }
            double[] dArray = a[i];
            int n11 = i--;
            dArray[n11] = dArray[n11] + 1.0;
        }
        k = n - 1;
        while (k >= 0) {
            int its = 0;
            while (its < 30) {
                double z;
                double y;
                double c;
                boolean flag = true;
                l = k;
                while (l >= 0) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) + anorm == anorm) break;
                    --l;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    i = l;
                    while (i < k + 1) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = w[i];
                        w[i] = h = SVD.pythag(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        j = 0;
                        while (j < m) {
                            y = a[j][nm];
                            z = a[j][i];
                            a[j][nm] = y * c + z * s;
                            a[j][i] = z * c - y * s;
                            ++j;
                        }
                        ++i;
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) break;
                    w[k] = -z;
                    j = 0;
                    while (j < n) {
                        v[j][k] = -v[j][k];
                        ++j;
                    }
                    break;
                }
                double x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = SVD.pythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + SVD.SIGN(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                j = l;
                while (j <= nm) {
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = SVD.pythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 0;
                    while (jj < n) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                        ++jj;
                    }
                    w[j] = z = SVD.pythag(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 0;
                    while (jj < m) {
                        y = a[jj][j];
                        z = a[jj][i];
                        a[jj][j] = y * c + z * s;
                        a[jj][i] = z * c - y * s;
                        ++jj;
                    }
                    ++j;
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
                ++its;
            }
            --k;
        }
    }

    public static int MIN(int m, int n) {
        return m < n ? m : n;
    }

    public static double MAX(double a, double b) {
        return a > b ? a : b;
    }

    public static double SIGN(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    public static double pythag(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            return absa * Math.sqrt(1.0 + absb / absa * (absb / absa));
        }
        return absb == 0.0 ? 0.0 : absb * Math.sqrt(1.0 + absa / absb * (absa / absb));
    }
}

