/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.pnn;

import org.encog.neural.networks.training.pnn.CalculationCriteria;
import org.encog.neural.networks.training.pnn.GlobalMinimumSearch;
import org.encog.util.EngineArray;
import org.encog.util.logging.EncogLogging;

public class DeriveMinimum {
    public double calculate(int maxIterations, double maxError, double eps, double tol, CalculationCriteria network, int n, double[] x, double ystart, double[] base, double[] direc, double[] g, double[] h, double[] deriv2) {
        GlobalMinimumSearch globalMinimum = new GlobalMinimumSearch();
        double fbest = network.calcErrorWithMultipleSigma(x, direc, deriv2, true);
        double prevBest = 1.0E30;
        int i = 0;
        while (i < n) {
            direc[i] = -direc[i];
            ++i;
        }
        EngineArray.arrayCopy(direc, g);
        EngineArray.arrayCopy(direc, h);
        int convergenceCounter = 0;
        int poorCJ = 0;
        int iteration = 0;
        while (iteration < maxIterations) {
            int i2;
            if (fbest < maxError) break;
            EncogLogging.log(1, "Beginning internal Iteration #" + iteration + ", currentError=" + fbest + ",target=" + maxError);
            double toler = prevBest <= 1.0 ? tol : tol * prevBest;
            if (prevBest - fbest <= toler) {
                if (++convergenceCounter >= 3) {
                    break;
                }
            } else {
                convergenceCounter = 0;
            }
            double dot1 = 0.0;
            double dot2 = 0.0;
            double dlen = 0.0;
            dlen = 0.0;
            dot2 = 0.0;
            dot1 = 0.0;
            double high = 1.0E-4;
            int i3 = 0;
            while (i3 < n) {
                base[i3] = x[i3];
                if (deriv2[i3] > high) {
                    high = deriv2[i3];
                }
                dot1 += direc[i3] * g[i3];
                dot2 += direc[i3] * direc[i3] * deriv2[i3];
                dlen += direc[i3] * direc[i3];
                ++i3;
            }
            dlen = Math.sqrt(dlen);
            double scale = Math.abs(dot2) < 1.0E-13 ? 0.0 : dot1 / dot2;
            if ((high = 1.5 / high) < 1.0E-4) {
                high = 1.0E-4;
            }
            if (scale < 0.0) {
                scale = high;
            } else if (scale < 0.1 * high) {
                scale = 0.1 * high;
            } else if (scale > 10.0 * high) {
                scale = 10.0 * high;
            }
            prevBest = fbest;
            globalMinimum.setY2(fbest);
            globalMinimum.findBestRange(0.0, 2.0 * scale, -3, false, maxError, network);
            if (globalMinimum.getY2() < maxError) {
                if (globalMinimum.getY2() < fbest) {
                    i2 = 0;
                    while (i2 < n) {
                        x[i2] = base[i2] + globalMinimum.getY2() * direc[i2];
                        if (x[i2] < 1.0E-10) {
                            x[i2] = 1.0E-10;
                        }
                        ++i2;
                    }
                    fbest = globalMinimum.getY2();
                    break;
                }
                System.arraycopy(base, 0, x, 0, n);
                break;
            }
            fbest = convergenceCounter > 0 ? globalMinimum.brentmin(20, maxError, eps, 1.0E-7, network, globalMinimum.getY2()) : globalMinimum.brentmin(10, maxError, 1.0E-6, 1.0E-5, network, globalMinimum.getY2());
            i2 = 0;
            while (i2 < n) {
                x[i2] = base[i2] + globalMinimum.getX2() * direc[i2];
                if (x[i2] < 1.0E-10) {
                    x[i2] = 1.0E-10;
                }
                ++i2;
            }
            double improvement = (prevBest - fbest) / prevBest;
            if (fbest < maxError) break;
            i2 = 0;
            while (i2 < n) {
                direc[i2] = -direc[i2];
                ++i2;
            }
            double gam = this.gamma(n, g, direc);
            if (gam < 0.0) {
                gam = 0.0;
            }
            if (gam > 10.0) {
                gam = 10.0;
            }
            poorCJ = improvement < 0.001 ? ++poorCJ : 0;
            if (poorCJ >= 2 && gam > 1.0) {
                gam = 1.0;
            }
            if (poorCJ >= 6) {
                poorCJ = 0;
                gam = 0.0;
            }
            this.findNewDir(n, gam, g, h, direc);
            ++iteration;
        }
        return fbest;
    }

    private void findNewDir(int n, double gam, double[] g, double[] h, double[] grad) {
        System.arraycopy(grad, 0, g, 0, n);
        int i = 0;
        while (i < n) {
            grad[i] = h[i] = g[i] + gam * h[i];
            ++i;
        }
    }

    private double gamma(int n, double[] g, double[] grad) {
        double denom = 0.0;
        double numer = 0.0;
        int i = 0;
        while (i < n) {
            denom += g[i] * g[i];
            numer += (grad[i] - g[i]) * grad[i];
            ++i;
        }
        if (denom == 0.0) {
            return 0.0;
        }
        return numer / denom;
    }
}

