/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.cross;

import org.encog.ml.data.folded.FoldedDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.cross.CrossTraining;
import org.encog.neural.networks.training.cross.NetworkFold;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class CrossValidationKFold
extends CrossTraining {
    private final MLTrain train;
    private final NetworkFold[] networks;
    private final FlatNetwork flatNetwork;

    public CrossValidationKFold(MLTrain train, int k) {
        super(train.getMethod(), (FoldedDataSet)train.getTraining());
        this.train = train;
        this.getFolded().fold(k);
        this.flatNetwork = ((BasicNetwork)train.getMethod()).getStructure().getFlat();
        this.networks = new NetworkFold[k];
        int i = 0;
        while (i < this.networks.length) {
            this.networks[i] = new NetworkFold(this.flatNetwork);
            ++i;
        }
    }

    @Override
    public void iteration() {
        double error = 0.0;
        int valFold = 0;
        while (valFold < this.getFolded().getNumFolds()) {
            this.networks[valFold].copyToNetwork(this.flatNetwork);
            int curFold = 0;
            while (curFold < this.getFolded().getNumFolds()) {
                if (curFold != valFold) {
                    this.getFolded().setCurrentFold(curFold);
                    this.train.iteration();
                }
                ++curFold;
            }
            this.getFolded().setCurrentFold(valFold);
            double e = this.flatNetwork.calculateError(this.getFolded());
            error += e;
            this.networks[valFold].copyFromNetwork(this.flatNetwork);
            ++valFold;
        }
        this.setError(error / (double)this.getFolded().getNumFolds());
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }

    @Override
    public int getIteration() {
        return this.train.getIteration();
    }
}

