/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.encog.EncogError;
import org.encog.NullStatusReportable;
import org.encog.StatusReportable;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformer;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformerCPU;

public final class ConcurrentTrainingManager
implements Runnable {
    private static ConcurrentTrainingManager instance;
    private final Lock accessLock = new ReentrantLock();
    private final Condition mightBeDone = this.accessLock.newCondition();
    private int jobNumber;
    private boolean singleThreaded;
    private final List<ConcurrentTrainingPerformer> performers = new ArrayList<ConcurrentTrainingPerformer>();
    private final List<TrainingJob> queue = new ArrayList<TrainingJob>();
    private Thread thread;
    private StatusReportable report = new NullStatusReportable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentTrainingManager getInstance() {
        Class<ConcurrentTrainingManager> clazz = ConcurrentTrainingManager.class;
        synchronized (ConcurrentTrainingManager.class) {
            if (instance == null) {
                instance = new ConcurrentTrainingManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ConcurrentTrainingManager() {
    }

    public void addPerformer(ConcurrentTrainingPerformer performer) {
        try {
            this.accessLock.lock();
            this.performers.add(performer);
            performer.setManager(this);
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void addTrainingJob(TrainingJob job) {
        if (job.getStrategies().size() == 0) {
            throw new EncogError("Job has no strategies, it will have no way to know when to end.");
        }
        try {
            this.accessLock.lock();
            this.queue.add(job);
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void clearPerformers() {
        try {
            this.accessLock.lock();
            this.performers.clear();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void clearQueue() {
        try {
            this.accessLock.lock();
            this.queue.clear();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void detectPerformers() {
        this.detectPerformers(false);
    }

    public void detectPerformers(boolean splitCores) {
        try {
            int threads = 1;
            this.accessLock.lock();
            this.clearPerformers();
            this.setSingleThreaded(splitCores);
            if (splitCores) {
                Runtime runtime = Runtime.getRuntime();
                threads = runtime.availableProcessors();
            } else {
                threads = 1;
            }
            int cpuCount = 0;
            int i = 0;
            while (i < threads) {
                this.addPerformer(new ConcurrentTrainingPerformerCPU(cpuCount++));
                ++i;
            }
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    public void jobDone(long time, ConcurrentTrainingPerformerCPU perf) {
        try {
            ++this.jobNumber;
            this.reportStatus("Job finished in " + time + "ms, on " + perf.toString());
            this.accessLock.lock();
            this.mightBeDone.signal();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void reportErrors() {
        for (TrainingJob job : this.queue) {
            if (job.getError() == null) continue;
            throw new NeuralNetworkError(job.getError());
        }
    }

    private void reportStatus(String str) {
        this.report.report(this.queue.size(), this.jobNumber, str);
    }

    @Override
    public void run() {
        this.jobNumber = 0;
        this.report.report(this.queue.size(), 0, "Starting first job");
        int count = 0;
        for (TrainingJob job : this.queue) {
            ConcurrentTrainingPerformer perform = this.waitForFreePerformer();
            perform.perform(job);
            ++count;
            this.reportErrors();
        }
        boolean done = false;
        this.report.report(this.queue.size(), count, "No more jobs to submit, waiting for last job.");
        while (!done) {
            try {
                this.accessLock.lock();
                boolean foundOne = false;
                for (ConcurrentTrainingPerformer performer : this.performers) {
                    if (performer.ready()) continue;
                    foundOne = true;
                }
                if (foundOne) {
                    try {
                        this.mightBeDone.await();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                done = true;
            }
            finally {
                this.accessLock.unlock();
            }
        }
        this.report.report(this.queue.size(), count, "All training done.");
    }

    public void setReport(StatusReportable report) {
        this.report = report;
    }

    public void setSingleThreaded(boolean singleThreaded) {
        this.singleThreaded = singleThreaded;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int index = 1;
        for (ConcurrentTrainingPerformer performer : this.performers) {
            builder.append("Performer ");
            builder.append(index++);
            builder.append(": ");
            builder.append(performer.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public ConcurrentTrainingPerformer waitForFreePerformer() {
        try {
            this.accessLock.lock();
            ConcurrentTrainingPerformer result = null;
            while (result == null) {
                for (ConcurrentTrainingPerformer performer : this.performers) {
                    if (!performer.ready()) continue;
                    result = performer;
                }
                if (result != null) continue;
                try {
                    this.mightBeDone.await();
                }
                catch (InterruptedException e) {
                    this.accessLock.unlock();
                    return null;
                }
            }
            ConcurrentTrainingPerformer concurrentTrainingPerformer = result;
            return concurrentTrainingPerformer;
        }
        finally {
            this.accessLock.unlock();
        }
    }
}

