/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.opp.links;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.opp.links.SelectLinks;

public class SelectProportion
implements SelectLinks,
Serializable {
    private double proportion;
    private EvolutionaryAlgorithm trainer;

    public SelectProportion(double theProportion) {
        this.proportion = theProportion;
    }

    @Override
    public void init(EvolutionaryAlgorithm theTrainer) {
        this.trainer = theTrainer;
    }

    @Override
    public List<NEATLinkGene> selectLinks(Random rnd, NEATGenome genome) {
        ArrayList<NEATLinkGene> result = new ArrayList<NEATLinkGene>();
        boolean mutated = false;
        for (NEATLinkGene linkGene : genome.getLinksChromosome()) {
            if (!(rnd.nextDouble() < this.proportion)) continue;
            mutated = true;
            result.add(linkGene);
        }
        if (!mutated) {
            int idx = rnd.nextInt(genome.getLinksChromosome().size());
            NEATLinkGene linkGene = genome.getLinksChromosome().get(idx);
            result.add(linkGene);
        }
        return result;
    }

    @Override
    public EvolutionaryAlgorithm getTrainer() {
        return this.trainer;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.getClass().getSimpleName());
        result.append(":proportion=");
        result.append(this.proportion);
        result.append("]");
        return result.toString();
    }
}

