/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.opp;

import java.io.Serializable;
import java.util.Random;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.ea.genome.Genome;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATInnovation;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;
import org.encog.neural.neat.training.opp.NEATMutation;

public class NEATMutateAddNode
extends NEATMutation
implements Serializable {
    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        NEATGenome target = this.obtainGenome(parents, parentIndex, offspring, offspringIndex);
        int countTrysToFindOldLink = this.getOwner().getMaxTries();
        NEATPopulation pop = (NEATPopulation)target.getPopulation();
        NEATLinkGene splitLink = null;
        int sizeBias = ((NEATGenome)parents[0]).getInputCount() + ((NEATGenome)parents[0]).getOutputCount() + 10;
        int upperLimit = target.getLinksChromosome().size() < sizeBias ? target.getNumGenes() - 1 - (int)Math.sqrt(target.getNumGenes()) : target.getNumGenes() - 1;
        while (countTrysToFindOldLink-- > 0) {
            int i = RangeRandomizer.randomInt(0, upperLimit);
            NEATLinkGene link = target.getLinksChromosome().get(i);
            long fromNeuron = link.getFromNeuronID();
            if (!link.isEnabled() || target.getNeuronsChromosome().get(this.getElementPos(target, fromNeuron)).getNeuronType() == NEATNeuronType.Bias) continue;
            splitLink = link;
            break;
        }
        if (splitLink == null) {
            return;
        }
        splitLink.setEnabled(false);
        long from = splitLink.getFromNeuronID();
        long to = splitLink.getToNeuronID();
        NEATInnovation innovation = ((NEATPopulation)this.getOwner().getPopulation()).getInnovations().findInnovationSplit(from, to);
        ActivationFunction af = ((NEATPopulation)this.getOwner().getPopulation()).getActivationFunctions().pick(new Random());
        target.getNeuronsChromosome().add(new NEATNeuronGene(NEATNeuronType.Hidden, af, innovation.getNeuronID(), innovation.getInnovationID()));
        this.createLink(target, from, innovation.getNeuronID(), splitLink.getWeight());
        this.createLink(target, innovation.getNeuronID(), to, pop.getWeightRange());
        target.sortGenes();
    }
}

