/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.opp;

import java.io.Serializable;
import java.util.Random;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.ea.genome.Genome;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATNeuronGene;
import org.encog.neural.neat.training.opp.NEATMutation;

public class NEATMutateAddLink
extends NEATMutation
implements Serializable {
    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        int countTrysToAddLink = this.getOwner().getMaxTries();
        NEATGenome target = this.obtainGenome(parents, parentIndex, offspring, offspringIndex);
        long neuron1ID = -1L;
        long neuron2ID = -1L;
        while (countTrysToAddLink-- > 0) {
            NEATNeuronGene neuron1 = this.chooseRandomNeuron(target, true);
            NEATNeuronGene neuron2 = this.chooseRandomNeuron(target, false);
            if (neuron1 == null || neuron2 == null) {
                return;
            }
            if (this.isDuplicateLink(target, neuron1.getId(), neuron2.getId()) || neuron2.getNeuronType() == NEATNeuronType.Bias || neuron2.getNeuronType() == NEATNeuronType.Input || ((NEATPopulation)this.getOwner().getPopulation()).getActivationCycles() == 1 && neuron1.getNeuronType() == NEATNeuronType.Output) continue;
            neuron1ID = neuron1.getId();
            neuron2ID = neuron2.getId();
            break;
        }
        if (neuron1ID < 0L || neuron2ID < 0L) {
            return;
        }
        double r = ((NEATPopulation)target.getPopulation()).getWeightRange();
        this.createLink(target, neuron1ID, neuron2ID, RangeRandomizer.randomize(rnd, -r, r));
        target.sortGenes();
    }
}

