/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training;

import java.io.Serializable;
import org.encog.neural.neat.training.NEATBaseGene;

public class NEATLinkGene
extends NEATBaseGene
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long fromNeuronID;
    private long toNeuronID;
    private double weight;
    private boolean enabled = true;

    public NEATLinkGene() {
    }

    public NEATLinkGene(long fromNeuronID, long toNeuronID, boolean enabled, long innovationID, double weight) {
        this.fromNeuronID = fromNeuronID;
        this.toNeuronID = toNeuronID;
        this.setEnabled(enabled);
        this.setInnovationId(innovationID);
        this.weight = weight;
    }

    public NEATLinkGene(NEATLinkGene other) {
        this.copy(other);
    }

    public void copy(NEATLinkGene gene) {
        NEATLinkGene other = gene;
        this.setEnabled(other.isEnabled());
        this.fromNeuronID = other.fromNeuronID;
        this.toNeuronID = other.toNeuronID;
        this.setInnovationId(other.getInnovationId());
        this.weight = other.weight;
    }

    public long getFromNeuronID() {
        return this.fromNeuronID;
    }

    public long getToNeuronID() {
        return this.toNeuronID;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[NEATLinkGene:innov=");
        result.append(this.getInnovationId());
        result.append(",enabled=");
        result.append(this.isEnabled());
        result.append(",from=");
        result.append(this.fromNeuronID);
        result.append(",to=");
        result.append(this.toNeuronID);
        result.append("]");
        return result.toString();
    }

    public void setFromNeuronID(int i) {
        this.fromNeuronID = i;
    }

    public void setToNeuronID(int i) {
        this.toNeuronID = i;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }
}

