/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.Serializable;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.neural.neat.NEATLink;
import org.encog.util.EngineArray;
import org.encog.util.simple.EncogUtility;

public class NEATNetwork
implements MLRegression,
MLError,
Serializable {
    private static final long serialVersionUID = 3660295468309926508L;
    private final NEATLink[] links;
    private final ActivationFunction[] activationFunctions;
    private final double[] preActivation;
    private final double[] postActivation;
    private final int outputIndex;
    private int inputCount;
    private int outputCount;
    private int activationCycles = 4;
    private boolean hasRelaxed = false;
    private double relaxationThreshold;

    public NEATNetwork(int inputNeuronCount, int outputNeuronCount, List<NEATLink> connectionArray, ActivationFunction[] theActivationFunctions) {
        this.links = new NEATLink[connectionArray.size()];
        int i = 0;
        while (i < connectionArray.size()) {
            this.links[i] = connectionArray.get(i);
            ++i;
        }
        this.activationFunctions = theActivationFunctions;
        int neuronCount = this.activationFunctions.length;
        this.preActivation = new double[neuronCount];
        this.postActivation = new double[neuronCount];
        this.inputCount = inputNeuronCount;
        this.outputIndex = inputNeuronCount + 1;
        this.outputCount = outputNeuronCount;
        this.postActivation[0] = 1.0;
    }

    @Override
    public double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }

    @Override
    public MLData compute(MLData input) {
        BasicMLData result = new BasicMLData(this.outputCount);
        EngineArray.fill(this.preActivation, 0.0);
        EngineArray.fill(this.postActivation, 0.0);
        this.postActivation[0] = 1.0;
        EngineArray.arrayCopy(input.getData(), 0, this.postActivation, 1, this.inputCount);
        int i = 0;
        while (i < this.activationCycles) {
            this.internalCompute();
            ++i;
        }
        EngineArray.arrayCopy(this.postActivation, this.outputIndex, result.getData(), 0, this.outputCount);
        return result;
    }

    public int getActivationCycles() {
        return this.activationCycles;
    }

    public ActivationFunction[] getActivationFunctions() {
        return this.activationFunctions;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public NEATLink[] getLinks() {
        return this.links;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public double[] getPostActivation() {
        return this.postActivation;
    }

    public double[] getPreActivation() {
        return this.preActivation;
    }

    public double getRelaxationThreshold() {
        return this.relaxationThreshold;
    }

    private void internalCompute() {
        int j = 0;
        while (j < this.links.length) {
            int n = this.links[j].getToNeuron();
            this.preActivation[n] = this.preActivation[n] + this.postActivation[this.links[j].getFromNeuron()] * this.links[j].getWeight();
            ++j;
        }
        j = this.outputIndex;
        while (j < this.preActivation.length) {
            this.postActivation[j] = this.preActivation[j];
            this.activationFunctions[j].activationFunction(this.postActivation, j, 1);
            this.preActivation[j] = 0.0;
            ++j;
        }
    }

    public boolean isHasRelaxed() {
        return this.hasRelaxed;
    }

    public void setActivationCycles(int activationCycles) {
        this.activationCycles = activationCycles;
    }

    public void setHasRelaxed(boolean hasRelaxed) {
        this.hasRelaxed = hasRelaxed;
    }

    public void setRelaxationThreshold(double relaxationThreshold) {
        this.relaxationThreshold = relaxationThreshold;
    }
}

