/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.ml.ea.codec.GeneticCODEC;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.genetic.GeneticError;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.neat.NEATLink;
import org.encog.neural.neat.NEATNetwork;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;

public class NEATCODEC
implements GeneticCODEC,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public MLMethod decode(Genome genome) {
        NEATGenome neatGenome = (NEATGenome)genome;
        NEATPopulation pop = (NEATPopulation)neatGenome.getPopulation();
        List<NEATNeuronGene> neuronsChromosome = neatGenome.getNeuronsChromosome();
        List<NEATLinkGene> linksChromosome = neatGenome.getLinksChromosome();
        if (neuronsChromosome.get(0).getNeuronType() != NEATNeuronType.Bias) {
            throw new NeuralNetworkError("The first neuron must be the bias neuron, this genome is invalid.");
        }
        ArrayList<NEATLink> links = new ArrayList<NEATLink>();
        ActivationFunction[] afs = new ActivationFunction[neuronsChromosome.size()];
        int i = 0;
        while (i < afs.length) {
            afs[i] = neuronsChromosome.get(i).getActivationFunction();
            ++i;
        }
        HashMap<Long, Integer> lookup = new HashMap<Long, Integer>();
        int i2 = 0;
        while (i2 < neuronsChromosome.size()) {
            NEATNeuronGene neuronGene = neuronsChromosome.get(i2);
            lookup.put(neuronGene.getId(), i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < linksChromosome.size()) {
            NEATLinkGene linkGene = linksChromosome.get(i2);
            if (linkGene.isEnabled()) {
                links.add(new NEATLink((Integer)lookup.get(linkGene.getFromNeuronID()), (Integer)lookup.get(linkGene.getToNeuronID()), linkGene.getWeight()));
            }
            ++i2;
        }
        Collections.sort(links);
        NEATNetwork network = new NEATNetwork(neatGenome.getInputCount(), neatGenome.getOutputCount(), links, afs);
        network.setActivationCycles(pop.getActivationCycles());
        return network;
    }

    @Override
    public Genome encode(MLMethod phenotype) {
        throw new GeneticError("Encoding of a NEAT network is not supported.");
    }
}

