/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.flat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.mathutil.error.ErrorCalculation;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.flat.FlatLayer;
import org.encog.util.EngineArray;

public class FlatNetwork
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_BIAS_ACTIVATION = 1.0;
    public static final double NO_BIAS_ACTIVATION = 0.0;
    private int inputCount;
    private int[] layerCounts;
    private double[] layerDropoutRates;
    private int[] layerContextCount;
    private int[] layerFeedCounts;
    private int[] layerIndex;
    private double[] layerOutput;
    private double[] layerSums;
    private int outputCount;
    private int[] weightIndex;
    private double[] weights;
    private ActivationFunction[] activationFunctions;
    private int[] contextTargetOffset;
    private int[] contextTargetSize;
    private double[] biasActivation;
    private int beginTraining;
    private int endTraining;
    private boolean isLimited;
    private double connectionLimit;
    private boolean hasContext;

    public FlatNetwork() {
        this.layerDropoutRates = new double[0];
    }

    public FlatNetwork(FlatLayer[] layers) {
        this.init(layers, false);
    }

    public FlatNetwork(FlatLayer[] layers, boolean dropout) {
        this.init(layers, dropout);
    }

    public FlatNetwork(int input, int hidden1, int hidden2, int output, boolean tanh) {
        FlatLayer[] layers;
        ActivationFunction act;
        ActivationLinear linearAct = new ActivationLinear();
        ActivationFunction activationFunction = act = tanh ? new ActivationTANH() : new ActivationSigmoid();
        if (hidden1 == 0 && hidden2 == 0) {
            layers = new FlatLayer[]{new FlatLayer(linearAct, input, 1.0), new FlatLayer(act, output, 0.0)};
        } else if (hidden1 == 0 || hidden2 == 0) {
            int count = Math.max(hidden1, hidden2);
            layers = new FlatLayer[]{new FlatLayer(linearAct, input, 1.0), new FlatLayer(act, count, 1.0), new FlatLayer(act, output, 0.0)};
        } else {
            layers = new FlatLayer[]{new FlatLayer(linearAct, input, 1.0), new FlatLayer(act, hidden1, 1.0), new FlatLayer(act, hidden2, 1.0), new FlatLayer(act, output, 0.0)};
        }
        this.isLimited = false;
        this.connectionLimit = 0.0;
        this.init(layers, false);
    }

    public double calculateError(MLDataSet data) {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        double[] actual = new double[this.outputCount];
        MLDataPair pair = BasicMLDataPair.createPair(data.getInputSize(), data.getIdealSize());
        int i = 0;
        while ((long)i < data.getRecordCount()) {
            data.getRecord(i, pair);
            this.compute(pair.getInputArray(), actual);
            errorCalculation.updateError(actual, pair.getIdealArray(), pair.getSignificance());
            ++i;
        }
        return errorCalculation.calculate();
    }

    public void clearConnectionLimit() {
        this.connectionLimit = 0.0;
        this.isLimited = false;
    }

    public void clearContext() {
        int index = 0;
        int i = 0;
        while (i < this.layerIndex.length) {
            boolean hasBias = this.layerContextCount[i] + this.layerFeedCounts[i] != this.layerCounts[i];
            Arrays.fill(this.layerOutput, index, index + this.layerFeedCounts[i], 0.0);
            index += this.layerFeedCounts[i];
            if (hasBias) {
                this.layerOutput[index++] = this.biasActivation[i];
            }
            Arrays.fill(this.layerOutput, index, index + this.layerContextCount[i], 0.0);
            index += this.layerContextCount[i];
            ++i;
        }
    }

    public FlatNetwork clone() {
        FlatNetwork result = new FlatNetwork();
        this.cloneFlatNetwork(result);
        return result;
    }

    public void cloneFlatNetwork(FlatNetwork result) {
        result.inputCount = this.inputCount;
        result.layerCounts = EngineArray.arrayCopy(this.layerCounts);
        result.layerIndex = EngineArray.arrayCopy(this.layerIndex);
        result.layerOutput = EngineArray.arrayCopy(this.layerOutput);
        result.layerSums = EngineArray.arrayCopy(this.layerSums);
        result.layerFeedCounts = EngineArray.arrayCopy(this.layerFeedCounts);
        result.contextTargetOffset = EngineArray.arrayCopy(this.contextTargetOffset);
        result.contextTargetSize = EngineArray.arrayCopy(this.contextTargetSize);
        result.layerContextCount = EngineArray.arrayCopy(this.layerContextCount);
        result.biasActivation = EngineArray.arrayCopy(this.biasActivation);
        result.outputCount = this.outputCount;
        result.weightIndex = this.weightIndex;
        result.weights = this.weights;
        result.layerDropoutRates = EngineArray.arrayCopy(this.layerDropoutRates);
        result.activationFunctions = new ActivationFunction[this.activationFunctions.length];
        int i = 0;
        while (i < result.activationFunctions.length) {
            result.activationFunctions[i] = this.activationFunctions[i].clone();
            ++i;
        }
        result.beginTraining = this.beginTraining;
        result.endTraining = this.endTraining;
    }

    public void compute(double[] input, double[] output) {
        int sourceIndex = this.layerOutput.length - this.layerCounts[this.layerCounts.length - 1];
        EngineArray.arrayCopy(input, 0, this.layerOutput, sourceIndex, this.inputCount);
        int i = this.layerIndex.length - 1;
        while (i > 0) {
            this.computeLayer(i);
            --i;
        }
        int offset = this.contextTargetOffset[0];
        EngineArray.arrayCopy(this.layerOutput, 0, this.layerOutput, offset, this.contextTargetSize[0]);
        EngineArray.arrayCopy(this.layerOutput, 0, output, 0, this.outputCount);
    }

    protected void computeLayer(int currentLayer) {
        int inputIndex = this.layerIndex[currentLayer];
        int outputIndex = this.layerIndex[currentLayer - 1];
        int inputSize = this.layerCounts[currentLayer];
        int outputSize = this.layerFeedCounts[currentLayer - 1];
        double dropoutRate = this.layerDropoutRates.length > currentLayer - 1 ? this.layerDropoutRates[currentLayer - 1] : 0.0;
        int index = this.weightIndex[currentLayer - 1];
        int limitX = outputIndex + outputSize;
        int limitY = inputIndex + inputSize;
        int x = outputIndex;
        while (x < limitX) {
            double sum = 0.0;
            int y = inputIndex;
            while (y < limitY) {
                sum += this.weights[index++] * this.layerOutput[y] * (1.0 - dropoutRate);
                ++y;
            }
            this.layerSums[x] = sum;
            this.layerOutput[x] = sum;
            ++x;
        }
        this.activationFunctions[currentLayer - 1].activationFunction(this.layerOutput, outputIndex, outputSize);
        int offset = this.contextTargetOffset[currentLayer];
        EngineArray.arrayCopy(this.layerOutput, outputIndex, this.layerOutput, offset, this.contextTargetSize[currentLayer]);
    }

    public void decodeNetwork(double[] data) {
        if (data.length != this.weights.length) {
            throw new EncogError("Incompatible weight sizes, can't assign length=" + data.length + " to length=" + this.weights.length);
        }
        this.weights = EngineArray.arrayCopy(data);
    }

    public double[] encodeNetwork() {
        return this.weights;
    }

    public ActivationFunction[] getActivationFunctions() {
        return this.activationFunctions;
    }

    public int getBeginTraining() {
        return this.beginTraining;
    }

    public double[] getBiasActivation() {
        return this.biasActivation;
    }

    public double getConnectionLimit() {
        return this.connectionLimit;
    }

    public int[] getContextTargetOffset() {
        return this.contextTargetOffset;
    }

    public int[] getContextTargetSize() {
        return this.contextTargetSize;
    }

    public int getEncodeLength() {
        return this.weights.length;
    }

    public int getEndTraining() {
        return this.endTraining;
    }

    public boolean getHasContext() {
        return this.hasContext;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int[] getLayerContextCount() {
        return this.layerContextCount;
    }

    public int[] getLayerCounts() {
        return this.layerCounts;
    }

    public int[] getLayerFeedCounts() {
        return this.layerFeedCounts;
    }

    public int[] getLayerIndex() {
        return this.layerIndex;
    }

    public double[] getLayerOutput() {
        return this.layerOutput;
    }

    public int getNeuronCount() {
        int result = 0;
        int[] nArray = this.layerCounts;
        int n = this.layerCounts.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            result += element;
            ++n2;
        }
        return result;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public int[] getWeightIndex() {
        return this.weightIndex;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public Class<?> hasSameActivationFunction() {
        ArrayList map = new ArrayList();
        ActivationFunction[] activationFunctionArray = this.activationFunctions;
        int n = this.activationFunctions.length;
        int n2 = 0;
        while (n2 < n) {
            ActivationFunction activation = activationFunctionArray[n2];
            if (!map.contains(activation.getClass())) {
                map.add(activation.getClass());
            }
            ++n2;
        }
        if (map.size() != 1) {
            return null;
        }
        return (Class)map.get(0);
    }

    public void init(FlatLayer[] layers, boolean dropout) {
        int layerCount = layers.length;
        this.inputCount = layers[0].getCount();
        this.outputCount = layers[layerCount - 1].getCount();
        this.layerCounts = new int[layerCount];
        this.layerContextCount = new int[layerCount];
        this.weightIndex = new int[layerCount];
        this.layerIndex = new int[layerCount];
        this.layerDropoutRates = dropout ? new double[layerCount] : new double[0];
        this.activationFunctions = new ActivationFunction[layerCount];
        this.layerFeedCounts = new int[layerCount];
        this.contextTargetOffset = new int[layerCount];
        this.contextTargetSize = new int[layerCount];
        this.biasActivation = new double[layerCount];
        int index = 0;
        int neuronCount = 0;
        int weightCount = 0;
        int i = layers.length - 1;
        while (i >= 0) {
            FlatLayer layer = layers[i];
            FlatLayer nextLayer = null;
            if (i > 0) {
                nextLayer = layers[i - 1];
            }
            this.biasActivation[index] = layer.getBiasActivation();
            this.layerCounts[index] = layer.getTotalCount();
            this.layerFeedCounts[index] = layer.getCount();
            this.layerContextCount[index] = layer.getContextCount();
            this.activationFunctions[index] = layer.getActivation();
            if (dropout) {
                this.layerDropoutRates[index] = layer.getDropoutRate();
            }
            neuronCount += layer.getTotalCount();
            if (nextLayer != null) {
                weightCount += layer.getCount() * nextLayer.getTotalCount();
            }
            if (index == 0) {
                this.weightIndex[index] = 0;
                this.layerIndex[index] = 0;
            } else {
                this.weightIndex[index] = this.weightIndex[index - 1] + this.layerCounts[index] * this.layerFeedCounts[index - 1];
                this.layerIndex[index] = this.layerIndex[index - 1] + this.layerCounts[index - 1];
            }
            int neuronIndex = 0;
            int j = layers.length - 1;
            while (j >= 0) {
                if (layers[j].getContextFedBy() == layer) {
                    this.hasContext = true;
                    this.contextTargetSize[index] = layers[j].getContextCount();
                    this.contextTargetOffset[index] = neuronIndex + (layers[j].getTotalCount() - layers[j].getContextCount());
                }
                neuronIndex += layers[j].getTotalCount();
                --j;
            }
            ++index;
            --i;
        }
        this.beginTraining = 0;
        this.endTraining = this.layerCounts.length - 1;
        this.weights = new double[weightCount];
        this.layerOutput = new double[neuronCount];
        this.layerSums = new double[neuronCount];
        this.clearContext();
    }

    public boolean isLimited() {
        return this.isLimited;
    }

    public void randomize() {
        this.randomize(1.0, -1.0);
    }

    public void randomize(double hi, double lo) {
        int i = 0;
        while (i < this.weights.length) {
            this.weights[i] = Math.random() * (hi - lo) + lo;
            ++i;
        }
    }

    public void setActivationFunctions(ActivationFunction[] af) {
        this.activationFunctions = Arrays.copyOf(af, af.length);
    }

    public void setBeginTraining(int beginTraining) {
        this.beginTraining = beginTraining;
    }

    public void setBiasActivation(double[] biasActivation) {
        this.biasActivation = biasActivation;
    }

    public void setConnectionLimit(double connectionLimit) {
        this.connectionLimit = connectionLimit;
        if (Math.abs(this.connectionLimit - 1.0E-10) < 1.0E-13) {
            this.isLimited = true;
        }
    }

    public void setContextTargetOffset(int[] contextTargetOffset) {
        this.contextTargetOffset = EngineArray.arrayCopy(contextTargetOffset);
    }

    public void setContextTargetSize(int[] contextTargetSize) {
        this.contextTargetSize = EngineArray.arrayCopy(contextTargetSize);
    }

    public void setEndTraining(int endTraining) {
        this.endTraining = endTraining;
    }

    public void setHasContext(boolean hasContext) {
        this.hasContext = hasContext;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public void setLayerContextCount(int[] layerContextCount) {
        this.layerContextCount = EngineArray.arrayCopy(layerContextCount);
    }

    public void setLayerCounts(int[] layerCounts) {
        this.layerCounts = EngineArray.arrayCopy(layerCounts);
    }

    public void setLayerFeedCounts(int[] layerFeedCounts) {
        this.layerFeedCounts = EngineArray.arrayCopy(layerFeedCounts);
    }

    public void setLayerIndex(int[] i) {
        this.layerIndex = EngineArray.arrayCopy(i);
    }

    public void setLayerOutput(double[] layerOutput) {
        this.layerOutput = EngineArray.arrayCopy(layerOutput);
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public void setWeightIndex(int[] weightIndex) {
        this.weightIndex = EngineArray.arrayCopy(weightIndex);
    }

    public void setWeights(double[] weights) {
        this.weights = EngineArray.arrayCopy(weights);
    }

    public double[] getLayerSums() {
        return this.layerSums;
    }

    public void setLayerSums(double[] d) {
        this.layerSums = EngineArray.arrayCopy(d);
    }

    public double[] getLayerDropoutRates() {
        return this.layerDropoutRates;
    }

    public void setLayerDropoutRates(double[] layerDropoutRates) {
        this.layerDropoutRates = layerDropoutRates;
    }

    public double getWeight(int fromLayer, int fromNeuron, int toNeuron) {
        this.validateNeuron(fromLayer, fromNeuron);
        this.validateNeuron(fromLayer + 1, toNeuron);
        int fromLayerNumber = this.layerContextCount.length - fromLayer - 1;
        int toLayerNumber = fromLayerNumber - 1;
        if (toLayerNumber < 0) {
            throw new NeuralNetworkError("The specified layer is not connected to another layer: " + fromLayer);
        }
        int weightBaseIndex = this.weightIndex[toLayerNumber];
        int count = this.layerCounts[fromLayerNumber];
        int weightIndex = weightBaseIndex + fromNeuron + toNeuron * count;
        return this.weights[weightIndex];
    }

    public void validateNeuron(int targetLayer, int neuron) {
        if (targetLayer < 0 || targetLayer >= this.layerCounts.length) {
            throw new NeuralNetworkError("Invalid layer count: " + targetLayer);
        }
        if (neuron < 0 || neuron >= this.getLayerTotalNeuronCount(targetLayer)) {
            throw new NeuralNetworkError("Invalid neuron number: " + neuron);
        }
    }

    public int getLayerTotalNeuronCount(int l) {
        int layerNumber = this.layerCounts.length - l - 1;
        return this.layerCounts[layerNumber];
    }

    public int getLayerNeuronCount(int l) {
        int layerNumber = this.layerCounts.length - l - 1;
        return this.layerFeedCounts[layerNumber];
    }
}

