/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.cpn;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.ConsistentRandomizer;
import org.encog.ml.BasicML;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.util.simple.EncogUtility;

public class CPN
extends BasicML
implements MLRegression,
MLResettable,
MLError {
    private static final long serialVersionUID = 1L;
    private final int inputCount;
    private final int instarCount;
    private final int outstarCount;
    private final int winnerCount;
    private final Matrix weightsInputToInstar;
    private final Matrix weightsInstarToOutstar;

    public CPN(int theInputCount, int theInstarCount, int theOutstarCount, int theWinnerCount) {
        this.inputCount = theInputCount;
        this.instarCount = theInstarCount;
        this.outstarCount = theOutstarCount;
        this.weightsInputToInstar = new Matrix(this.inputCount, this.instarCount);
        this.weightsInstarToOutstar = new Matrix(this.instarCount, this.outstarCount);
        this.winnerCount = theWinnerCount;
    }

    @Override
    public double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }

    @Override
    public MLData compute(MLData input) {
        MLData temp = this.computeInstar(input);
        return this.computeOutstar(temp);
    }

    public MLData computeInstar(MLData input) {
        BasicMLData result = new BasicMLData(this.instarCount);
        int winner = 0;
        boolean[] winners = new boolean[this.instarCount];
        int i = 0;
        while (i < this.instarCount) {
            double sum = 0.0;
            int j = 0;
            while (j < this.inputCount) {
                sum += this.weightsInputToInstar.get(j, i) * input.getData(j);
                ++j;
            }
            result.setData(i, sum);
            winners[i] = false;
            ++i;
        }
        double sumWinners = 0.0;
        int w = 0;
        while (w < this.winnerCount) {
            double maxOut = Double.MIN_VALUE;
            i = 0;
            while (i < this.instarCount) {
                if (!winners[i] && result.getData(i) > maxOut) {
                    winner = i;
                    maxOut = result.getData(winner);
                }
                ++i;
            }
            winners[winner] = true;
            sumWinners += result.getData(winner);
            ++w;
        }
        i = 0;
        while (i < this.instarCount) {
            if (winners[i] && Math.abs(sumWinners) > 1.0E-13) {
                double[] dArray = result.getData();
                int n = i;
                dArray[n] = dArray[n] / sumWinners;
            } else {
                result.getData()[i] = 0.0;
            }
            ++i;
        }
        return result;
    }

    public MLData computeOutstar(MLData input) {
        BasicMLData result = new BasicMLData(this.outstarCount);
        double sum = 0.0;
        int i = 0;
        while (i < this.outstarCount) {
            sum = 0.0;
            int j = 0;
            while (j < this.instarCount) {
                sum += this.weightsInstarToOutstar.get(j, i) * input.getData(j);
                ++j;
            }
            result.setData(i, sum);
            ++i;
        }
        return result;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public int getInstarCount() {
        return this.instarCount;
    }

    @Override
    public int getOutputCount() {
        return this.outstarCount;
    }

    public int getOutstarCount() {
        return this.outstarCount;
    }

    public Matrix getWeightsInputToInstar() {
        return this.weightsInputToInstar;
    }

    public Matrix getWeightsInstarToOutstar() {
        return this.weightsInstarToOutstar;
    }

    public int getWinnerCount() {
        return this.winnerCount;
    }

    @Override
    public void reset() {
        this.reset(0);
    }

    @Override
    public void reset(int seed) {
        ConsistentRandomizer randomize = new ConsistentRandomizer(-1.0, 1.0, seed);
        randomize.randomize(this.weightsInputToInstar);
        randomize.randomize(this.weightsInstarToOutstar);
    }

    @Override
    public void updateProperties() {
    }
}

