/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy.end;

import java.io.Serializable;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;
import org.encog.util.obj.SerializeObject;

public class StoppingStrategy
implements EndTrainingStrategy {
    private MLTrain train;
    private boolean stop;
    private double lastError;
    private MLRegression model;
    private int allowedStagnantIterations;
    private int stagnantIterations;
    private MLRegression bestModel;
    private boolean saveBest;
    private double bestError;
    private double minimumImprovement = 1.0E-13;

    public StoppingStrategy(MLDataSet theValidationSet) {
        this(50);
    }

    public StoppingStrategy(int theAllowedStagnantIterations) {
        this.allowedStagnantIterations = theAllowedStagnantIterations;
    }

    @Override
    public void init(MLTrain theTrain) {
        this.train = theTrain;
        this.model = (MLRegression)this.train.getMethod();
        this.stop = false;
        this.lastError = Double.POSITIVE_INFINITY;
    }

    @Override
    public void preIteration() {
    }

    @Override
    public void postIteration() {
        double trainingError = this.train.getError();
        double improve = this.bestError - trainingError;
        improve = Math.max(improve, 0.0);
        if (Double.isInfinite(trainingError) || Double.isNaN(trainingError)) {
            this.stop = true;
        } else if (this.bestError <= trainingError && !Double.isInfinite(this.lastError) && improve < this.minimumImprovement) {
            ++this.stagnantIterations;
            if (this.stagnantIterations > this.allowedStagnantIterations) {
                this.stop = true;
            }
        } else {
            if (this.saveBest) {
                this.bestModel = (MLRegression)((Object)SerializeObject.serializeClone((Serializable)((Object)this.model)));
            }
            this.bestError = trainingError;
            this.stagnantIterations = 0;
        }
        this.lastError = trainingError;
    }

    @Override
    public boolean shouldStop() {
        return this.stop;
    }

    public int getStagnantIterations() {
        return this.stagnantIterations;
    }

    public void setStagnantIterations(int stagnantIterations) {
        this.stagnantIterations = stagnantIterations;
    }

    public int getAllowedStagnantIterations() {
        return this.allowedStagnantIterations;
    }

    public void setAllowedStagnantIterations(int allowedStagnantIterations) {
        this.allowedStagnantIterations = allowedStagnantIterations;
    }

    public boolean isSaveBest() {
        return this.saveBest;
    }

    public void setSaveBest(boolean saveBest) {
        this.saveBest = saveBest;
    }

    public MLRegression getBestModel() {
        return this.bestModel;
    }

    public double getMinimumImprovement() {
        return this.minimumImprovement;
    }

    public void setMinimumImprovement(double minimumImprovement) {
        this.minimumImprovement = minimumImprovement;
    }
}

