/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.train;

import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.population.BasicPopulation;
import org.encog.ml.ea.species.Species;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.train.PrgGenomeFactory;
import org.encog.parse.expression.common.RenderCommonExpression;

public class PrgPopulation
extends BasicPopulation
implements MLRegression {
    private static final long serialVersionUID = 1L;
    private final EncogProgramContext context;

    public PrgPopulation(EncogProgramContext theContext, int thePopulationSize) {
        super(thePopulationSize, new PrgGenomeFactory(theContext));
        this.context = theContext;
    }

    @Override
    public MLData compute(MLData input) {
        EncogProgram best = (EncogProgram)this.getBestGenome();
        return best.compute(input);
    }

    public void dumpMembers(int i) {
        RenderCommonExpression render = new RenderCommonExpression();
        int index = 0;
        block0: for (Species species : this.getSpecies()) {
            System.out.println("** Species: " + species.toString());
            for (Genome obj : species.getMembers()) {
                EncogProgram prg = (EncogProgram)obj;
                System.out.println(String.valueOf(index) + ": Score " + prg.getScore() + " : " + render.render(prg));
                if (++index > i) continue block0;
            }
        }
    }

    public EncogProgramContext getContext() {
        return this.context;
    }

    @Override
    public int getInputCount() {
        return this.getContext().getDefinedVariables().size();
    }

    @Override
    public int getOutputCount() {
        return 1;
    }
}

