/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.opp;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.generator.PrgGenerator;
import org.encog.ml.prg.generator.PrgGrowGenerator;

public class SubtreeMutation
implements EvolutionaryOperator {
    private PrgGenerator generator;
    private final int maxDepth;

    public SubtreeMutation(EncogProgramContext theContext, int theMaxDepth) {
        this.generator = new PrgGrowGenerator(theContext, theMaxDepth);
        this.maxDepth = theMaxDepth;
    }

    private void findNode(Random rnd, EncogProgram result, ProgramNode parentNode, List<ValueType> types, int[] globalIndex) {
        if (globalIndex[0] == 0) {
            globalIndex[0] = globalIndex[0] - 1;
            ProgramNode newInsert = this.generator.createNode(rnd, result, this.maxDepth, types);
            result.replaceNode(parentNode, newInsert);
        } else {
            globalIndex[0] = globalIndex[0] - 1;
            int i = 0;
            while (i < parentNode.getTemplate().getChildNodeCount()) {
                ProgramNode childNode = parentNode.getChildNode(i);
                List<ValueType> childTypes = parentNode.getTemplate().getParams().get(i).determineArgumentTypes(types);
                this.findNode(rnd, result, childNode, childTypes, globalIndex);
                ++i;
            }
        }
    }

    public PrgGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
    }

    @Override
    public int offspringProduced() {
        return 1;
    }

    @Override
    public int parentsNeeded() {
        return 1;
    }

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        EncogProgram program = (EncogProgram)parents[0];
        EncogProgramContext context = program.getContext();
        EncogProgram result = context.cloneProgram(program);
        ArrayList<ValueType> types = new ArrayList<ValueType>();
        types.add(context.getResult().getVariableType());
        int[] globalIndex = new int[]{rnd.nextInt(result.getRootNode().size())};
        this.findNode(rnd, result, result.getRootNode(), types, globalIndex);
        offspring[0] = result;
    }

    public void setGenerator(PrgGenerator generator) {
        this.generator = generator;
    }
}

