/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.expvalue;

import org.encog.ml.prg.expvalue.DivisionByZeroError;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.expvalue.ValueType;

public final class EvaluateExpr {
    public static ExpressionValue add(ExpressionValue a, ExpressionValue b) {
        if (a.isString() || b.isString()) {
            return new ExpressionValue(String.valueOf(a.toStringValue()) + b.toStringValue());
        }
        if (a.isInt() && b.isInt()) {
            return new ExpressionValue(a.toIntValue() + b.toIntValue());
        }
        return new ExpressionValue(a.toFloatValue() + b.toFloatValue());
    }

    public static ExpressionValue div(ExpressionValue a, ExpressionValue b) {
        if (a.isInt() && b.isInt()) {
            long i = b.toIntValue();
            if (i == 0L) {
                throw new DivisionByZeroError();
            }
            return new ExpressionValue(a.toIntValue() / i);
        }
        double denom = b.toFloatValue();
        if (Math.abs(denom) < 1.0E-13) {
            throw new DivisionByZeroError();
        }
        return new ExpressionValue(a.toFloatValue() / denom);
    }

    public static ExpressionValue equ(ExpressionValue a, ExpressionValue b) {
        if (a.getExpressionType() == ValueType.booleanType) {
            return new ExpressionValue(a.toBooleanValue() == b.toBooleanValue());
        }
        if (a.getExpressionType() == ValueType.enumType) {
            return new ExpressionValue(a.toIntValue() == b.toIntValue() && a.getEnumType() == b.getEnumType());
        }
        if (a.getExpressionType() == ValueType.stringType) {
            return new ExpressionValue(a.toStringValue().equals(b.toStringValue()));
        }
        double diff = Math.abs(a.toFloatValue() - b.toFloatValue());
        return new ExpressionValue(diff < 1.0E-13);
    }

    public static ExpressionValue mul(ExpressionValue a, ExpressionValue b) {
        if (a.isInt() && b.isInt()) {
            return new ExpressionValue(a.toIntValue() * b.toIntValue());
        }
        return new ExpressionValue(a.toFloatValue() * b.toFloatValue());
    }

    public static ExpressionValue notequ(ExpressionValue a, ExpressionValue b) {
        if (a.getExpressionType() == ValueType.booleanType) {
            return new ExpressionValue(a.toBooleanValue() ^ b.toBooleanValue());
        }
        if (a.getExpressionType() == ValueType.enumType) {
            return new ExpressionValue(a.toIntValue() != b.toIntValue() && a.getEnumType() == b.getEnumType());
        }
        if (a.getExpressionType() == ValueType.stringType) {
            return new ExpressionValue(!a.toStringValue().equals(b.toStringValue()));
        }
        double diff = Math.abs(a.toFloatValue() - b.toFloatValue());
        return new ExpressionValue(diff > 1.0E-13);
    }

    public static ExpressionValue pow(ExpressionValue a, ExpressionValue b) {
        if (a.isInt() && b.isInt()) {
            return new ExpressionValue(Math.pow(a.toIntValue(), b.toIntValue()));
        }
        return new ExpressionValue(Math.pow(a.toFloatValue(), b.toFloatValue()));
    }

    public static ExpressionValue protectedDiv(ExpressionValue a, ExpressionValue b) {
        if (a.isInt() && b.isInt()) {
            long i = b.toIntValue();
            if (i == 0L) {
                return new ExpressionValue(1L);
            }
            return new ExpressionValue(a.toIntValue() / i);
        }
        double denom = b.toFloatValue();
        if (Math.abs(denom) < 1.0E-13) {
            return new ExpressionValue(1L);
        }
        return new ExpressionValue(a.toFloatValue() / denom);
    }

    public static ExpressionValue sub(ExpressionValue a, ExpressionValue b) {
        if (a.isInt() && b.isInt()) {
            return new ExpressionValue(a.toIntValue() - b.toIntValue());
        }
        return new ExpressionValue(a.toFloatValue() - b.toFloatValue());
    }

    private EvaluateExpr() {
    }
}

